/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.rest.representation.identity;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.rest.representation.identity.ExternalIDRepresentation;
import com.cumulocity.rest.representation.support.BDDJsonRepresentationTestBase;
import com.cumulocity.rest.representation.support.TestJsonProvider;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class ExternalIDRepresentationTest
extends BDDJsonRepresentationTestBase<ExternalIDRepresentation> {
    ExternalIDRepresentationTest() {
    }

    @ParameterizedTest
    @EnumSource(value=TestJsonProvider.class)
    void shouldDeserializeToRepresentation(TestJsonProvider provider) {
        this.givenJsonString("{\"externalId\":\"EXT-ID2\",\"type\":\"TYPE-2\",\"managedObject\":{\"id\":\"321\"}}");
        this.whenDeserializedUsing(provider);
        this.thenReturnedExternalId().hasExternalId("EXT-ID2").hasType("TYPE-2").hasManagedObjectWithId(GId.asGId((Long)321L));
    }

    private ExternalIdRepresentationAssert thenReturnedExternalId() {
        return new ExternalIdRepresentationAssert((ExternalIDRepresentation)this.getRepresentation());
    }

    private static final class ExternalIdRepresentationAssert {
        private final ExternalIDRepresentation rep;

        public ExternalIdRepresentationAssert hasExternalId(String externalId) {
            Assertions.assertThat((String)this.rep.getExternalId()).isEqualTo(externalId);
            return this;
        }

        public ExternalIdRepresentationAssert hasType(String type) {
            Assertions.assertThat((String)this.rep.getType()).isEqualTo(type);
            return this;
        }

        public ExternalIdRepresentationAssert hasManagedObjectWithId(GId id) {
            Assertions.assertThat((Object)this.rep.getManagedObject()).isNotNull();
            Assertions.assertThat((Object)this.rep.getManagedObject().getId()).isEqualTo((Object)id);
            return this;
        }

        @Generated
        public ExternalIdRepresentationAssert(ExternalIDRepresentation rep) {
            this.rep = rep;
        }

        @Generated
        public ExternalIDRepresentation getRep() {
            return this.rep;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExternalIdRepresentationAssert)) {
                return false;
            }
            ExternalIdRepresentationAssert other = (ExternalIdRepresentationAssert)o;
            ExternalIDRepresentation this$rep = this.getRep();
            ExternalIDRepresentation other$rep = other.getRep();
            return !(this$rep == null ? other$rep != null : !this$rep.equals(other$rep));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExternalIDRepresentation $rep = this.getRep();
            result = result * 59 + ($rep == null ? 43 : $rep.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExternalIDRepresentationTest.ExternalIdRepresentationAssert(rep=" + this.getRep() + ")";
        }
    }
}

