/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.rest.representation.builder;

import com.cumulocity.model.util.DateTimeUtils;
import com.cumulocity.rest.representation.alarm.AlarmRepresentation;
import com.cumulocity.rest.representation.builder.AlarmRepresentationBuilder;
import com.cumulocity.rest.representation.builder.RestRepresentationObjectBuilder;
import org.joda.time.DateTime;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SampleAlarmRepresentation {
    ALARM_REPRESENTATION{

        @Override
        public AlarmRepresentationBuilder builder() {
            return RestRepresentationObjectBuilder.anAlarmRepresentation().withSeverity(SampleAlarmRepresentation.ALARM_SEVERITY).withStatus(SampleAlarmRepresentation.ALARM_STATUS).withType(SampleAlarmRepresentation.ALARM_TYPE).withText(SampleAlarmRepresentation.ALARM_TEXT).withDateTime(ALARM_TIME);
        }
    };

    public static final String ALARM_SEVERITY = "Alarm severity #";
    public static final String ALARM_STATUS = "Alarm status #";
    public static final String ALARM_TYPE = "Alarm Type #";
    public static final String ALARM_TEXT = "Alarm Text #";
    public static final DateTime ALARM_TIME;

    public abstract AlarmRepresentationBuilder builder();

    public AlarmRepresentation build() {
        return (AlarmRepresentation)this.builder().build();
    }

    static {
        ALARM_TIME = DateTimeUtils.nowUTC();
    }
}

