/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model;

import com.cumulocity.model.ID;
import com.cumulocity.model.idtype.GId;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.svenson.JSONParseException;
import org.svenson.converter.TypeConverter;

public class IDTypeConverter
implements TypeConverter {
    private static Logger logger = LoggerFactory.getLogger(IDTypeConverter.class);
    private static final String VALUENAME = "value";
    private static final String TYPENAME = "type";
    private static final String NAMENAME = "name";

    public Object fromJSON(Object in) {
        block11: {
            if (in == null) {
                return in;
            }
            if (in instanceof ID) {
                ID inId = (ID)((Object)in);
                String clazz = inId.getType().replace('_', '.');
                if (clazz != in.getClass().getCanonicalName()) {
                    try {
                        ID typeInstance = (ID)((Object)Class.forName(clazz).newInstance());
                        typeInstance.setValue(inId.getValue());
                        typeInstance.setName(inId.getName());
                        return typeInstance;
                    }
                    catch (Exception e) {
                        logger.debug("Parameter type of " + inId.getType() + " is not a known class. ID type returned.");
                        return new ID(inId);
                    }
                }
                return in;
            }
            if (in instanceof String) {
                return new GId((String)in);
            }
            if (in instanceof Map) {
                Map idMap = (Map)in;
                try {
                    if (idMap.containsKey(TYPENAME) && idMap.containsKey(VALUENAME)) {
                        ID thisId = new ID();
                        thisId.setType((String)idMap.remove(TYPENAME));
                        thisId.setValue((String)idMap.remove(VALUENAME));
                        thisId.setName((String)idMap.remove(NAMENAME));
                        for (String key : idMap.keySet()) {
                            thisId.setProperty(key, idMap.get(key));
                        }
                        return this.fromJSON((Object)thisId);
                    }
                    break block11;
                }
                catch (ClassCastException e) {
                    throw new JSONParseException("Incompatible types creating ID class: " + e.getLocalizedMessage());
                }
            }
            throw new JSONParseException("Malformed ID list, embedded type found: " + in.getClass().getCanonicalName());
        }
        return in;
    }

    public Object toJSON(Object in) {
        return in;
    }
}

