/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.customdecoders.api.util;

import com.cumulocity.microservice.customdecoders.api.util.BIT_BYTE_WORD_ORDER;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Formatter;
import org.joda.time.DateTime;

public final class DecoderUtils {
    public static String toHexString(byte[] bytes) {
        Formatter formatter = new Formatter();
        for (byte b : bytes) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    public static byte[] hexStringToByteArray(String str) {
        int len = str.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(str.charAt(i), 16) << 4) + Character.digit(str.charAt(i + 1), 16));
        }
        return data;
    }

    public static DateTime toDateTime(long timestamp) {
        Date date = new Date(timestamp * 1000L);
        return new DateTime((Object)date);
    }

    public static String convertHexToBinary(String hex) {
        Integer binaryLength = hex.length() * 4;
        String binaryString = new BigInteger(hex, 16).toString(2);
        Integer paddingLength = binaryLength - binaryString.length();
        StringBuilder stringBuilder = new StringBuilder(binaryString);
        for (int i = paddingLength.intValue(); i > 0; --i) {
            stringBuilder.insert(0, "0");
        }
        return stringBuilder.toString();
    }

    public static Float toFloatFromHexString(String input) {
        Long i = Long.parseLong(input, 16);
        Float f = Float.valueOf(Float.intBitsToFloat(i.intValue()));
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        return Float.valueOf(decimalFormat.format(f));
    }

    public static byte[] reverseBitEndianness(byte[] raw, boolean reverseBitEndianness) {
        if (reverseBitEndianness) {
            byte[] reversed = new byte[raw.length];
            for (int i = 0; i < raw.length; ++i) {
                reversed[i] = DecoderUtils.reverse(raw[i]);
            }
            return reversed;
        }
        return raw;
    }

    public static byte reverse(byte value) {
        byte y = 0;
        for (int position = 7; position >= 0; --position) {
            y = (byte)(y + (byte)((value & 1) << position));
            value = (byte)(value >> 1);
        }
        return y;
    }

    public static float toFloat(short hbits) {
        int mant = hbits & 0x3FF;
        int exp = hbits & 0x7C00;
        if (exp == 31744) {
            exp = 261120;
        } else if (exp != 0) {
            if (mant == 0 && (exp += 114688) > 115712) {
                return Float.intBitsToFloat((hbits & 0x8000) << 16 | exp << 13 | 0x3FF);
            }
        } else if (mant != 0) {
            exp = 115712;
            do {
                exp -= 1024;
            } while (((mant <<= 1) & 0x400) == 0);
            mant &= 0x3FF;
        }
        return Float.intBitsToFloat((hbits & 0x8000) << 16 | (exp | mant) << 13);
    }

    public static byte extractBits(int number, int numOfBits, int fromIndex) {
        return (byte)((1 << numOfBits) - 1 & number >> fromIndex - 1);
    }

    public static int limitTo16Bits(int inputValue) {
        if (inputValue > 65535) {
            return 65535;
        }
        if (inputValue < 0) {
            return 0;
        }
        return inputValue;
    }

    private static String reorderfromLSBtoMSB(String input) {
        String[] subIndividualPayloadEncodedEnergyIndexIdentifier = input.split("(?<=\\G.{2})");
        String reArranged = subIndividualPayloadEncodedEnergyIndexIdentifier[3] + subIndividualPayloadEncodedEnergyIndexIdentifier[2] + subIndividualPayloadEncodedEnergyIndexIdentifier[1] + subIndividualPayloadEncodedEnergyIndexIdentifier[0];
        return reArranged;
    }

    private static byte[] reorderReverseBits(byte[] rawInputData) {
        if (rawInputData.length == 1 || rawInputData.length == 2 || rawInputData.length == 4 || rawInputData.length == 8) {
            byte[] reorderedArray = new byte[rawInputData.length];
            int index = 0;
            for (int currentIndex = rawInputData.length - 1; currentIndex >= 0; --currentIndex) {
                reorderedArray[index++] = DecoderUtils.reverse(rawInputData[currentIndex]);
            }
            return reorderedArray;
        }
        return rawInputData;
    }

    private static void swap(byte[] inputArray, int index1, int index2) {
        byte temp = inputArray[index1];
        inputArray[index1] = inputArray[index2];
        inputArray[index2] = temp;
    }

    private static byte[] reorderReverseBytes(byte[] rawInputData) {
        if (rawInputData.length == 2 || rawInputData.length == 4 || rawInputData.length == 8) {
            for (int currentIndex = 0; currentIndex < rawInputData.length; currentIndex += 2) {
                DecoderUtils.swap(rawInputData, currentIndex, currentIndex + 1);
            }
        }
        return rawInputData;
    }

    private static byte[] reorderReverseByteWords(byte[] rawInputData) {
        if (rawInputData.length == 2 || rawInputData.length == 4 || rawInputData.length == 8) {
            for (int currentIndex = 0; currentIndex < rawInputData.length; currentIndex += 4) {
                int left = currentIndex;
                for (int right = Math.min(currentIndex + 3, rawInputData.length - 1); left < right; ++left, --right) {
                    DecoderUtils.swap(rawInputData, left, right);
                }
            }
        }
        return rawInputData;
    }

    private static byte[] reorderReverseWords(byte[] rawInputData) {
        if (rawInputData.length == 4 || rawInputData.length == 8) {
            for (int index = 0; index < rawInputData.length; index += 4) {
                for (int currentIndex = index; currentIndex < index + 2; ++currentIndex) {
                    DecoderUtils.swap(rawInputData, currentIndex, currentIndex + 2);
                }
            }
        }
        return rawInputData;
    }

    public static double parseAsFloatingPoint(ByteBuffer buffer) {
        switch (buffer.remaining()) {
            case 8: {
                return buffer.getDouble();
            }
            case 4: {
                return buffer.getFloat();
            }
            case 2: {
                return DecoderUtils.toFloat(buffer.getShort());
            }
        }
        return 0.0;
    }

    public static long parseAsLong(ByteBuffer buffer, boolean signed) {
        switch (buffer.remaining()) {
            case 8: {
                return buffer.getLong();
            }
            case 4: {
                if (signed) {
                    return buffer.getInt();
                }
                return Integer.toUnsignedLong(buffer.getInt());
            }
            case 2: {
                if (signed) {
                    return buffer.getShort();
                }
                return Short.toUnsignedLong(buffer.getShort());
            }
            case 1: {
                if (signed) {
                    return buffer.get();
                }
                return Byte.toUnsignedLong(buffer.get());
            }
        }
        return 0L;
    }

    public static byte[] reorder(byte[] raw, BIT_BYTE_WORD_ORDER order) {
        switch (order) {
            case Reverse_Bits: {
                return DecoderUtils.reorderReverseBits(raw);
            }
            case Reverse_Bytes: {
                return DecoderUtils.reorderReverseBytes(raw);
            }
            case Reverse_Byte_Words: {
                return DecoderUtils.reorderReverseByteWords(raw);
            }
            case Reverse_Words: {
                return DecoderUtils.reorderReverseWords(raw);
            }
        }
        return raw;
    }
}

