/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.customdecoders.api.util;

import com.cumulocity.microservice.customdecoders.api.util.BIT_BYTE_WORD_ORDER;
import com.cumulocity.microservice.customdecoders.api.util.DecoderUtils;
import com.cumulocity.microservice.customdecoders.api.util.REGISTER_DATA_TYPE;
import java.nio.ByteBuffer;

public class ValueTranslator {
    public static double translate(byte[] raw, REGISTER_DATA_TYPE valueType, boolean signed, boolean reverseBitEndianness, BIT_BYTE_WORD_ORDER order, int multiplier, int divisor, int rightShift) {
        byte[] reordered = DecoderUtils.reorder(DecoderUtils.reverseBitEndianness(raw, reverseBitEndianness), order);
        double value = 0.0;
        if (valueType == REGISTER_DATA_TYPE.Integer) {
            value = DecoderUtils.parseAsLong(ByteBuffer.wrap(reordered), signed);
        } else if (valueType == REGISTER_DATA_TYPE.Float) {
            value = DecoderUtils.parseAsFloatingPoint(ByteBuffer.wrap(reordered));
        }
        if (multiplier != 0) {
            value *= (double)multiplier;
        }
        if (divisor != 0) {
            value /= (double)divisor;
        }
        if (rightShift != 0) {
            double shiftMultiplier = 1.0;
            if (rightShift > 0) {
                for (int i = 0; i < rightShift; ++i) {
                    shiftMultiplier *= 0.1;
                }
            } else {
                for (int i = 0; i > rightShift; --i) {
                    shiftMultiplier *= 10.0;
                }
            }
            value *= shiftMultiplier;
        }
        return value;
    }
}

