/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.customdecoders.api.model;

import com.cumulocity.microservice.customdecoders.api.model.DataFragmentUpdate;
import com.cumulocity.microservice.customdecoders.api.model.MeasurementDto;
import com.cumulocity.microservice.customdecoders.api.util.ObjectUtils;
import com.cumulocity.model.event.CumulocityAlarmStatuses;
import com.cumulocity.rest.representation.BaseResourceRepresentation;
import com.cumulocity.rest.representation.alarm.AlarmRepresentation;
import com.cumulocity.rest.representation.event.EventRepresentation;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.svenson.JSONTypeHint;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DecoderResult
extends BaseResourceRepresentation
implements Serializable {
    private List<AlarmRepresentation> internalServiceAlarms;
    private List<EventRepresentation> internalServiceEvents;
    private List<AlarmRepresentation> alarms;
    private Map<String, List<String>> alarmTypesToUpdate;
    private List<EventRepresentation> events;
    private List<MeasurementDto> measurements;
    private List<DataFragmentUpdate> dataFragments;
    private String message;
    private boolean success = true;

    public static DecoderResult empty() {
        return new DecoderResult();
    }

    public final DecoderResult setAsFailed(String message) {
        this.success = false;
        this.message = message;
        this.clearParsedData();
        this.alarms = this.internalServiceAlarms;
        this.events = this.internalServiceEvents;
        return this;
    }

    public void addAlarm(AlarmRepresentation alarmRepresentation, boolean internal) {
        if (ObjectUtils.isNull(this.alarms)) {
            this.alarms = new ArrayList<AlarmRepresentation>();
        }
        this.alarms.add(alarmRepresentation);
        if (internal) {
            this.addInternalAlarm(alarmRepresentation);
        }
    }

    public void addAlarms(Collection<AlarmRepresentation> alarmRepresentations) {
        if (ObjectUtils.isNull(this.alarms)) {
            this.alarms = new ArrayList<AlarmRepresentation>();
        }
        this.alarms.addAll(alarmRepresentations);
    }

    public void addAlarmTypesToClear(String ... alarmTypes) {
        this.addAlarmTypesToUpdate(CumulocityAlarmStatuses.CLEARED, alarmTypes);
    }

    public void addAlarmTypesToAcknowledge(String ... alarmTypes) {
        this.addAlarmTypesToUpdate(CumulocityAlarmStatuses.ACKNOWLEDGED, alarmTypes);
    }

    public void addAlarmTypesToUpdate(CumulocityAlarmStatuses status, String ... alarmTypes) {
        if (ObjectUtils.isNull(alarmTypes) || ObjectUtils.isEmpty(alarmTypes) || ObjectUtils.isNull(status)) {
            return;
        }
        if (ObjectUtils.isNull(this.alarmTypesToUpdate)) {
            this.alarmTypesToUpdate = new HashMap<String, List<String>>();
        }
        if (!this.alarmTypesToUpdate.containsKey(status.name())) {
            this.alarmTypesToUpdate.put(status.name(), new ArrayList());
        }
        Collections.addAll((Collection)this.alarmTypesToUpdate.get(status.name()), alarmTypes);
    }

    public void addEvent(EventRepresentation eventRepresentation, boolean internal) {
        if (ObjectUtils.isNull(this.events)) {
            this.events = new ArrayList<EventRepresentation>();
        }
        this.events.add(eventRepresentation);
        if (internal) {
            this.addInternalEvent(eventRepresentation);
        }
    }

    public void addMeasurement(MeasurementDto measurementDto) {
        if (ObjectUtils.isNull(this.measurements)) {
            this.measurements = new ArrayList<MeasurementDto>();
        }
        this.measurements.add(measurementDto);
    }

    public void addMeasurements(Collection<MeasurementDto> measurementDtoCollection) {
        if (ObjectUtils.isNull(this.measurements)) {
            this.measurements = new ArrayList<MeasurementDto>();
        }
        this.measurements.addAll(measurementDtoCollection);
    }

    public void addDataFragment(DataFragmentUpdate dataFragmentUpdate) {
        if (ObjectUtils.isNull(this.dataFragments)) {
            this.dataFragments = new ArrayList<DataFragmentUpdate>();
        }
        this.dataFragments.add(dataFragmentUpdate);
    }

    private void addInternalAlarm(AlarmRepresentation alarmRepresentation) {
        if (ObjectUtils.isNull(this.internalServiceAlarms)) {
            this.internalServiceAlarms = new ArrayList<AlarmRepresentation>();
        }
        this.internalServiceAlarms.add(alarmRepresentation);
    }

    private void addInternalEvent(EventRepresentation eventRepresentation) {
        if (ObjectUtils.isNull(this.internalServiceEvents)) {
            this.internalServiceEvents = new ArrayList<EventRepresentation>();
        }
        this.internalServiceEvents.add(eventRepresentation);
    }

    private void clearParsedData() {
        if (!ObjectUtils.isNull(this.alarms)) {
            this.alarms.clear();
        }
        if (!ObjectUtils.isNull(this.alarmTypesToUpdate)) {
            this.alarmTypesToUpdate.clear();
        }
        if (!ObjectUtils.isNull(this.events)) {
            this.events.clear();
        }
        if (!ObjectUtils.isNull(this.measurements)) {
            this.measurements.clear();
        }
        if (!ObjectUtils.isNull(this.dataFragments)) {
            this.dataFragments.clear();
        }
    }

    @JSONTypeHint(value=AlarmRepresentation.class)
    public List<AlarmRepresentation> getAlarms() {
        return this.alarms;
    }

    @JSONTypeHint(value=EventRepresentation.class)
    public List<EventRepresentation> getEvents() {
        return this.events;
    }

    @JSONTypeHint(value=MeasurementDto.class)
    public List<MeasurementDto> getMeasurements() {
        return this.measurements;
    }

    @JSONTypeHint(value=DataFragmentUpdate.class)
    public List<DataFragmentUpdate> getDataFragments() {
        return this.dataFragments;
    }

    public Map<String, List<String>> getAlarmTypesToUpdate() {
        return this.alarmTypesToUpdate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecoderResult that = (DecoderResult)o;
        return this.success == that.success && Objects.equals(this.internalServiceAlarms, that.internalServiceAlarms) && Objects.equals(this.internalServiceEvents, that.internalServiceEvents) && Objects.equals(this.alarms, that.alarms) && Objects.equals(this.alarmTypesToUpdate, that.alarmTypesToUpdate) && Objects.equals(this.events, that.events) && Objects.equals(this.measurements, that.measurements) && Objects.equals(this.dataFragments, that.dataFragments) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.internalServiceAlarms, this.internalServiceEvents, this.alarms, this.alarmTypesToUpdate, this.events, this.measurements, this.dataFragments, this.message, this.success);
    }

    @Generated
    public DecoderResult() {
    }

    @Generated
    public void setInternalServiceAlarms(List<AlarmRepresentation> internalServiceAlarms) {
        this.internalServiceAlarms = internalServiceAlarms;
    }

    @Generated
    public void setInternalServiceEvents(List<EventRepresentation> internalServiceEvents) {
        this.internalServiceEvents = internalServiceEvents;
    }

    @Generated
    public void setAlarms(List<AlarmRepresentation> alarms) {
        this.alarms = alarms;
    }

    @Generated
    public void setAlarmTypesToUpdate(Map<String, List<String>> alarmTypesToUpdate) {
        this.alarmTypesToUpdate = alarmTypesToUpdate;
    }

    @Generated
    public void setEvents(List<EventRepresentation> events) {
        this.events = events;
    }

    @Generated
    public void setMeasurements(List<MeasurementDto> measurements) {
        this.measurements = measurements;
    }

    @Generated
    public void setDataFragments(List<DataFragmentUpdate> dataFragments) {
        this.dataFragments = dataFragments;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }
}

