/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.customdecoders.api.model;

import com.cumulocity.microservice.customdecoders.api.model.DecoderInputData;
import com.cumulocity.microservice.customdecoders.api.model.ExecutionEventStatus;
import com.cumulocity.microservice.customdecoders.api.util.DecoderUtils;
import com.cumulocity.rest.representation.event.EventRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import org.joda.time.DateTime;

public class Decoder
implements Serializable {
    public static final String DECODER_EVENT_TYPE = "c8y_decoder_event";
    public static final String DECODER_DATA_FRAGMENT = "decoderData";
    private String serviceKey;
    private String displayName;

    public EventRepresentation createEvent(byte[] value, ManagedObjectRepresentation deviceMo, Map<String, String> args) {
        EventRepresentation event = new EventRepresentation();
        event.setText("External decoder data received from device. Decoder: " + this.serviceKey + " (" + this.displayName + ")");
        event.setType(DECODER_EVENT_TYPE);
        event.setDateTime(new DateTime());
        event.setSource(deviceMo);
        event.set((Object)new DecoderInputData(this.serviceKey, DecoderUtils.toHexString(value), args, deviceMo.getId().getValue(), ExecutionEventStatus.PENDING), DECODER_DATA_FRAGMENT);
        return event;
    }

    @Generated
    public Decoder(String serviceKey, String displayName) {
        this.serviceKey = serviceKey;
        this.displayName = displayName;
    }

    @Generated
    public Decoder() {
    }

    @Generated
    public String getServiceKey() {
        return this.serviceKey;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }
}

