/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.subscription.model;

import com.cumulocity.opcua.client.gateway.mappings.model.EventMappingParameters;
import com.cumulocity.opcua.client.gateway.subscription.model.BaseSubscriptionData;
import com.cumulocity.opcua.client.gateway.subscription.model.NodeEventTypeId;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscriptionEventData;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.util.CollectionUtils;

public class SubscriptionEventData
extends BaseSubscriptionData {
    private Map<NodeEventTypeId, EventMappingParameters> eventSubscriptions;

    public SubscriptionEventData(String serverId, String deviceTypeId, String rootNodeId, Map<NodeEventTypeId, EventMappingParameters> eventSubscriptions) {
        super(serverId, deviceTypeId, rootNodeId);
        this.eventSubscriptions = eventSubscriptions;
    }

    public void putEventSubscription(NodeEventTypeId nodeEventTypeId, EventMappingParameters mappingParameters) {
        if (Objects.isNull(this.eventSubscriptions)) {
            this.eventSubscriptions = new HashMap();
        }
        this.eventSubscriptions.put(nodeEventTypeId, mappingParameters);
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty((Map)this.eventSubscriptions);
    }

    public static SubscriptionEventDataBuilder builder() {
        return new SubscriptionEventDataBuilder();
    }

    public Map<NodeEventTypeId, EventMappingParameters> getEventSubscriptions() {
        return this.eventSubscriptions;
    }

    public void setEventSubscriptions(Map<NodeEventTypeId, EventMappingParameters> eventSubscriptions) {
        this.eventSubscriptions = eventSubscriptions;
    }

    public String toString() {
        return "SubscriptionEventData(eventSubscriptions=" + this.getEventSubscriptions() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionEventData)) {
            return false;
        }
        SubscriptionEventData other = (SubscriptionEventData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map this$eventSubscriptions = this.getEventSubscriptions();
        Map other$eventSubscriptions = other.getEventSubscriptions();
        return !(this$eventSubscriptions == null ? other$eventSubscriptions != null : !((Object)this$eventSubscriptions).equals(other$eventSubscriptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionEventData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map $eventSubscriptions = this.getEventSubscriptions();
        result = result * 59 + ($eventSubscriptions == null ? 43 : ((Object)$eventSubscriptions).hashCode());
        return result;
    }
}

