/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.subscription;

import c8y.ua.ClientConfig;
import c8y.ua.data.CyclicReadParameters;
import com.cumulocity.opcua.client.NodeIds;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.cyclicreader.CyclicReadExecutor;
import com.cumulocity.opcua.client.gateway.cyclicreader.model.CyclicReadDefinition;
import com.cumulocity.opcua.client.gateway.mappings.model.DataMappingParameters;
import com.cumulocity.opcua.client.gateway.subscription.SubscriptionService;
import com.cumulocity.opcua.client.gateway.subscription.model.BaseSubscriptionData;
import com.cumulocity.opcua.client.gateway.subscription.model.CyclicReadGroupKey;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscribedItem;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscribedItemId;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscriptionData;
import com.cumulocity.opcua.client.gateway.subscription.repository.SubscriptionRepository;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.common.NamespaceTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="crSubscriptionService")
public class CyclicReadSubscriptionService
implements SubscriptionService {
    private static final Logger log = LoggerFactory.getLogger(CyclicReadSubscriptionService.class);
    @Autowired
    private SubscriptionRepository subscriptionRepository;
    @Autowired
    private CyclicReadExecutor cyclicReadExecutor;
    @Autowired
    private ConnectionManager connectionManager;
    @Value(value="${gateway.cyclicRead.defaultBulkSize:1000}")
    private int defaultBulkSize = 1000;

    public <T extends BaseSubscriptionData> void applySubscriptions(String serverId, T subscriptionData) {
        Optional client;
        if (!(subscriptionData instanceof SubscriptionData)) {
            return;
        }
        Optional clientConfig = this.connectionManager.getClientConfig(ServerIdentifier.of((String)serverId));
        if (!clientConfig.isPresent()) {
            log.warn("Server not connected: {}", (Object)serverId);
            return;
        }
        ArrayList<SubscribedItem> items = new ArrayList<SubscribedItem>();
        HashMap groupedCyclicReads = new HashMap();
        AtomicInteger bulkCounter = new AtomicInteger();
        int bulkSize = this.defaultBulkSize;
        Integer serverConfiguredBulkSize = ((ClientConfig)clientConfig.get()).getCyclicReadBulkSize();
        if (Objects.nonNull(serverConfiguredBulkSize)) {
            bulkSize = serverConfiguredBulkSize;
        }
        if (!(client = this.connectionManager.getConnection(ServerIdentifier.of((String)serverId))).isPresent()) {
            log.warn("Server not connected: {}", (Object)serverId);
            return;
        }
        for (Map.Entry entry : ((SubscriptionData)subscriptionData).getNodeSubscriptions().entrySet()) {
            if (!this.isCyclicReadSubscription((DataMappingParameters)entry.getValue())) continue;
            SubscribedItem subscribedItem = SubscribedItem.builder().deviceTypeId(subscriptionData.getDeviceTypeId()).rootNodeId(subscriptionData.getRootNodeId()).subscribedItemId(new SubscribedItemId(serverId, subscriptionData.getRootNodeId(), (String)entry.getKey(), subscriptionData.getDeviceTypeId())).mappedActions(((DataMappingParameters)entry.getValue()).getMappingActions()).subscriptionType(this.getSubscriptionType()).build();
            items.add(subscribedItem);
            this.groupCyclicReads((SubscriptionData)subscriptionData, groupedCyclicReads, bulkCounter, bulkSize, entry);
        }
        for (Map.Entry entry : groupedCyclicReads.entrySet()) {
            CyclicReadParameters cyclicReadParameters = ((CyclicReadGroupKey)entry.getKey()).getParameters();
            NodeId[] nodeIds = (NodeId[])((List)entry.getValue()).stream().map(nodeId -> NodeIds.parseNodeId((String)NodeIds.toNodeId((NamespaceTable)((OpcuaClient)client.get()).getNamespaceTable(), (String)nodeId))).toArray(NodeId[]::new);
            this.cyclicReadExecutor.addCyclicRead(new CyclicReadDefinition(serverId, nodeIds, cyclicReadParameters.getRate().longValue(), Double.valueOf(cyclicReadParameters.getMaxAge()), subscriptionData.getDeviceTypeId(), subscriptionData.getRootNodeId()));
        }
        this.subscriptionRepository.addSubscribedItems(items);
    }

    public void removeSubscriptions(String serverId, String deviceTypeId, String rootNodeId) {
        this.subscriptionRepository.removeSubscribedNode(serverId, deviceTypeId, rootNodeId, this.getSubscriptionType());
        this.cyclicReadExecutor.removeCyclicReads(serverId, deviceTypeId, rootNodeId);
    }

    public void removeSubscriptions(String serverId, Collection<String> deviceTypeIds) {
        this.subscriptionRepository.removeSubscribedItemsForDeviceTypes(serverId, deviceTypeIds, this.getSubscriptionType());
        for (String deviceTypeId : deviceTypeIds) {
            this.cyclicReadExecutor.removeCyclicReads(serverId, deviceTypeId, null);
        }
    }

    public void removeServerSubscriptions(String serverId) {
        this.subscriptionRepository.removeServerSubscriptions(serverId, this.getSubscriptionType());
        this.cyclicReadExecutor.removeCyclicReads(serverId, null, null);
    }

    public String getSubscriptionType() {
        return "CyclicRead";
    }

    private boolean isCyclicReadSubscription(DataMappingParameters mappingParameters) {
        return Objects.nonNull(mappingParameters.getSubscriptionConfig()) && this.getSubscriptionType().equalsIgnoreCase(mappingParameters.getSubscriptionConfig().getType());
    }

    private void groupCyclicReads(SubscriptionData subscriptionData, Map<CyclicReadGroupKey, List<String>> groupedCyclicReads, AtomicInteger bulkCounter, int bulkSize, Map.Entry<String, DataMappingParameters> entry) {
        CyclicReadParameters cyclicReadParameters = entry.getValue().getSubscriptionConfig().getCyclicReadParameters();
        CyclicReadGroupKey cyclicReadGroupKey = new CyclicReadGroupKey(cyclicReadParameters, subscriptionData.getDeviceTypeId(), subscriptionData.getRootNodeId(), bulkCounter.get());
        if (groupedCyclicReads.containsKey(cyclicReadGroupKey)) {
            List<String> bulk = groupedCyclicReads.get(cyclicReadGroupKey);
            if (bulk.size() >= bulkSize) {
                cyclicReadGroupKey = this.getCyclicReadGroupKey(subscriptionData, bulkCounter.incrementAndGet(), cyclicReadParameters);
                groupedCyclicReads.put(cyclicReadGroupKey, new ArrayList<String>(Collections.singleton(entry.getKey())));
            } else {
                groupedCyclicReads.get(cyclicReadGroupKey).add(entry.getKey());
            }
        } else {
            groupedCyclicReads.put(cyclicReadGroupKey, new ArrayList<String>(Collections.singleton(entry.getKey())));
        }
    }

    private CyclicReadGroupKey getCyclicReadGroupKey(SubscriptionData subscriptionData, int bulkCounter, CyclicReadParameters cyclicReadParameters) {
        return new CyclicReadGroupKey(cyclicReadParameters, subscriptionData.getDeviceTypeId(), subscriptionData.getRootNodeId(), bulkCounter);
    }
}

