/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.subscription;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.connection.model.ServerDisconnectedEvent;
import com.cumulocity.opcua.client.gateway.exception.ServerNotConnectedException;
import com.cumulocity.opcua.client.gateway.mappings.model.DataMappingParameters;
import com.cumulocity.opcua.client.gateway.platform.repository.EventRepository;
import com.cumulocity.opcua.client.gateway.subscription.SubscriptionService;
import com.cumulocity.opcua.client.gateway.subscription.model.BaseSubscriptionData;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscriptionData;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscriptionEventData;
import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import com.cumulocity.rest.representation.event.EventRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="compositeSubscriptionService")
public class CompositeSubscriptionService
implements SubscriptionService {
    private static final Logger log = LoggerFactory.getLogger(CompositeSubscriptionService.class);
    @Autowired
    @Qualifier(value="uaSubscriptionService")
    private SubscriptionService uaSubscriptionService;
    @Autowired
    @Qualifier(value="nonSubscriptionService")
    private SubscriptionService noneSubscriptionService;
    @Autowired
    @Qualifier(value="crSubscriptionService")
    private SubscriptionService crSubscriptionService;
    @Autowired
    private EventRepository eventRepository;

    public <T extends BaseSubscriptionData> void applySubscriptions(String serverId, T subscriptionData) throws ServerNotConnectedException, OpcuaClientException {
        if (subscriptionData instanceof SubscriptionData) {
            this.applyForType(serverId, "Subscription", (SubscriptionData)subscriptionData);
            this.applyForType(serverId, "None", (SubscriptionData)subscriptionData);
            this.applyForType(serverId, "CyclicRead", (SubscriptionData)subscriptionData);
        } else if (subscriptionData instanceof SubscriptionEventData) {
            this.uaSubscriptionService.applySubscriptions(serverId, subscriptionData);
        }
        this.createSubscribeEvent(serverId, subscriptionData.getDeviceTypeId(), subscriptionData.getRootNodeId());
        log.info("Data type: {} has been applied to node: {} on server: {}", new Object[]{subscriptionData.getDeviceTypeId(), subscriptionData.getRootNodeId(), serverId});
    }

    public void removeSubscriptions(String serverId, String deviceTypeId, String rootNodeId) {
        this.noneSubscriptionService.removeSubscriptions(serverId, deviceTypeId, rootNodeId);
        this.crSubscriptionService.removeSubscriptions(serverId, deviceTypeId, rootNodeId);
        this.uaSubscriptionService.removeSubscriptions(serverId, deviceTypeId, rootNodeId);
        this.createUnsubscribeEvent(serverId, deviceTypeId, rootNodeId);
        log.info("Data type: {} has been un-applied for node: {} on server: {}", new Object[]{deviceTypeId, rootNodeId, serverId});
    }

    public void removeSubscriptions(String serverId, Collection<String> deviceTypeIds) {
        this.noneSubscriptionService.removeSubscriptions(serverId, deviceTypeIds);
        this.crSubscriptionService.removeSubscriptions(serverId, deviceTypeIds);
        this.uaSubscriptionService.removeSubscriptions(serverId, deviceTypeIds);
        deviceTypeIds.forEach(deviceTypeId -> this.createUnsubscribeEvent(serverId, deviceTypeId, null));
        log.info("Data types: {} have been un-applied for all nodes on server: {}", deviceTypeIds, (Object)serverId);
    }

    public void removeServerSubscriptions(String serverId) {
        this.noneSubscriptionService.removeServerSubscriptions(serverId);
        this.crSubscriptionService.removeServerSubscriptions(serverId);
        this.uaSubscriptionService.removeServerSubscriptions(serverId);
        this.createUnsubscribeEvent(serverId, null, null);
        log.info("All data types have been un-applied for all nodes on server: {}", (Object)serverId);
    }

    public void removeServerSubscriptions(ServerDisconnectedEvent serverDisconnectedEvent) {
        this.removeServerSubscriptions(serverDisconnectedEvent.getServerIdentifier().getInventoryIdentifier().getValue());
    }

    private void applyForType(String serverId, String type, SubscriptionData subscriptionData) throws ServerNotConnectedException, OpcuaClientException {
        SubscriptionData subscriptionOnly = this.getForType(subscriptionData, type);
        if (!subscriptionOnly.isEmpty()) {
            switch (type) {
                case "Subscription": {
                    this.uaSubscriptionService.applySubscriptions(serverId, (BaseSubscriptionData)subscriptionOnly);
                    break;
                }
                case "CyclicRead": {
                    this.crSubscriptionService.applySubscriptions(serverId, (BaseSubscriptionData)subscriptionOnly);
                    break;
                }
                case "None": {
                    this.noneSubscriptionService.applySubscriptions(serverId, (BaseSubscriptionData)subscriptionOnly);
                }
            }
        }
    }

    private SubscriptionData getForType(SubscriptionData subscriptionData, String type) {
        SubscriptionData revised = SubscriptionData.builder().deviceTypeId(subscriptionData.getDeviceTypeId()).rootNodeId(subscriptionData.getRootNodeId()).serverId(subscriptionData.getServerId()).build();
        for (Map.Entry entry : subscriptionData.getNodeSubscriptions().entrySet()) {
            if (!this.isSubscriptionType((DataMappingParameters)entry.getValue(), type)) continue;
            revised.putNodeSubscription((String)entry.getKey(), (DataMappingParameters)entry.getValue());
        }
        return revised;
    }

    private boolean isSubscriptionType(DataMappingParameters mappingParameters, String subscriptionType) {
        return Objects.nonNull(mappingParameters.getSubscriptionConfig()) && subscriptionType.equalsIgnoreCase(mappingParameters.getSubscriptionConfig().getType());
    }

    private EventRepresentation createBaseSubscriptionEvent(String serverId, String deviceTypeId, String rootNodeId, String type) {
        EventRepresentation event = new EventRepresentation();
        ManagedObjectRepresentation source = new ManagedObjectRepresentation();
        source.setId(GId.asGId((String)serverId));
        event.setSource(source);
        event.setType(type);
        event.set((Object)deviceTypeId, "deviceTypeId");
        event.set((Object)rootNodeId, "rootNodeId");
        event.setDateTime(DateTime.now());
        return event;
    }

    private void createSubscribeEvent(String serverId, String deviceTypeId, String rootNodeId) {
        EventRepresentation event = this.createBaseSubscriptionEvent(serverId, deviceTypeId, rootNodeId, "c8y_ua_DeviceTypeApplied");
        event.setText(String.format("Device type: %s is applied to root node: %s of server: %s", deviceTypeId, rootNodeId, serverId));
        this.eventRepository.addToQueue((AbstractExtensibleRepresentation)event);
    }

    private void createUnsubscribeEvent(String serverId, String deviceTypeId, String rootNodeId) {
        EventRepresentation event = this.createBaseSubscriptionEvent(serverId, deviceTypeId, rootNodeId, "c8y_ua_DeviceTypeUnapplied");
        if (StringUtils.isEmpty((CharSequence)rootNodeId) && StringUtils.isNotEmpty((CharSequence)deviceTypeId)) {
            event.setText(String.format("Device type: %s is un-applied from all nodes of server %s", deviceTypeId, serverId));
        } else if (StringUtils.isNotEmpty((CharSequence)deviceTypeId)) {
            event.setText(String.format("Device type: %s is un-applied from root node: %s of server: %s", deviceTypeId, rootNodeId, serverId));
        } else {
            event.setText(String.format("All device types are un-applied for server: %s", serverId));
        }
        this.eventRepository.addToQueue((AbstractExtensibleRepresentation)event);
    }

    public String getSubscriptionType() {
        return "Composite";
    }
}

