/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.repository;

import com.cumulocity.model.idtype.GId;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"gateway.thinEdge.useForDataForwarding"}, havingValue="true", matchIfMissing=false)
public class ThinEdgeAlarmRepository {
    private static final Logger log = LoggerFactory.getLogger(ThinEdgeAlarmRepository.class);
    @Autowired
    private MqttClient mqttClient;

    public boolean create(GId source, String type, String severity, String text) {
        return this.create(source, type, severity, text, null);
    }

    public boolean create(GId source, String type, String severity, String text, DateTime time) {
        try {
            String topic = "te/device/" + source.getValue() + "///a/" + type;
            MqttMessage message = new MqttMessage();
            Gson gson = new GsonBuilder().create();
            message.setPayload(gson.toJson((Object)this.buildThinEdgeAlarm(severity, text, time)).getBytes());
            this.mqttClient.publish(topic, message);
            return true;
        }
        catch (MqttException e) {
            log.error("Failed to publish MQTT message: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    private Map<String, Object> buildThinEdgeAlarm(String severity, String text, DateTime time) {
        HashMap<String, Object> alarmData = new HashMap<String, Object>();
        alarmData.put("time", time != null ? time.toString() : DateTime.now().toString());
        alarmData.put("text", text);
        alarmData.put("severity", severity);
        return alarmData;
    }
}

