/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.configuration;

import com.cumulocity.model.authentication.CumulocityCredentials;
import com.cumulocity.model.authentication.CumulocityMqttJwtProviderAuthentication;
import com.cumulocity.model.authentication.jwt.ErrorListener;
import com.cumulocity.model.authentication.jwt.JwtMqttTopics;
import com.cumulocity.model.authentication.jwt.JwtMqttTopicsThinEdge;
import com.cumulocity.model.authentication.jwt.JwtToken;
import com.cumulocity.model.authentication.jwt.JwtTokenProvider;
import com.cumulocity.model.authentication.jwt.JwtTokenProviderListener;
import com.cumulocity.opcua.client.gateway.bootstrap.model.JWTAvailableEvent;
import com.cumulocity.opcua.client.gateway.configuration.GatewayGeneralConfiguration;
import com.cumulocity.opcua.client.gateway.errorHandler.HttpUnauthorizedEvent;
import com.cumulocity.opcua.client.gateway.platform.configuration.BasePlatformFactory;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component(value="platformFactoryThinEdge")
@ConditionalOnProperty(value={"gateway.thinEdge.enabled"}, havingValue="true", matchIfMissing=false)
public class PlatformFactoryThinEdge
extends BasePlatformFactory
implements ErrorListener,
JwtTokenProviderListener {
    private static final Logger log = LoggerFactory.getLogger(PlatformFactoryThinEdge.class);
    @Value(value="${gateway.thinEdge.mqttServerURL}")
    private String mqttServerUrl;
    @Value(value="${gateway.thinEdge.deviceId}")
    private String thinEdgeDeviceId;
    @Value(value="${gateway.thinEdge.mqttSteadyConnection}")
    private Boolean mqttSteadyConnection;
    @Autowired
    private GatewayGeneralConfiguration gatewayGeneralConfiguration;
    private CumulocityMqttJwtProviderAuthentication credentials = new CumulocityMqttJwtProviderAuthentication();
    JwtTokenProvider jwtTokenProvider = null;
    private Instant lastJwtIntialization = Instant.MIN;

    public void onJWTAvailable(JWTAvailableEvent jwtAvailableEvent) {
        log.info("Create Platform for ThinEdge environment");
        if (Objects.nonNull(this.jwtTokenProvider)) {
            log.info("JWT provider already initialized. Ignoring");
            return;
        }
        this.initializeJWTProvider();
    }

    private void initializeJWTProvider() {
        try {
            this.lastJwtIntialization = Instant.now();
            log.debug("Initialize and start JWT provider.");
            this.instantiateJwtTokenProvider();
            this.jwtTokenProvider.start();
        }
        catch (Exception e) {
            log.error("JWT token provider failed to initialize and to connect. Please Check MQTT configuration and ThinEdge! Gateway is shutting down...");
            System.exit(1);
        }
    }

    protected void instantiateJwtTokenProvider() throws Exception {
        this.jwtTokenProvider = new JwtTokenProvider(this.mqttServerUrl, new Properties(), this.thinEdgeDeviceId, (JwtTokenProviderListener)this, (ErrorListener)this, (JwtMqttTopics)new JwtMqttTopicsThinEdge(), this.mqttSteadyConnection.booleanValue());
    }

    public synchronized void handle401ResponseOnThinEdge(HttpUnauthorizedEvent unauthorizedEvent) {
        int maxAgeLastJWTReinitSeconds = 10;
        if (Duration.between(this.lastJwtIntialization, Instant.now()).toSeconds() < (long)maxAgeLastJWTReinitSeconds) {
            log.info("JWT already initialized within the last {} seconds, ignoring");
            return;
        }
        log.warn("Thin Edge token may have expired, retriggering platform initialization.");
        this.initializeJWTProvider();
    }

    public void onError(ErrorListener.ErrorCode errorCode, String errorMessage) {
        log.error("Error, Code: " + errorCode.name() + ", Message: " + errorMessage);
        System.exit(1);
    }

    public void jwtTokenChange(JwtToken jwtToken) {
        this.credentials.jwtTokenChange(jwtToken);
        this.platform = this.initializePlatformWithCredentials((CumulocityCredentials)this.credentials);
        this.configurePlatform(this.credentials.getUsername());
    }

    void setMqttServerUrl(String mqttServerUrl) {
        this.mqttServerUrl = mqttServerUrl;
    }

    void setThinEdgeDeviceId(String thinEdgeDeviceId) {
        this.thinEdgeDeviceId = thinEdgeDeviceId;
    }

    void setMqttSteadyConnection(Boolean mqttSteadyConnection) {
        this.mqttSteadyConnection = mqttSteadyConnection;
    }

    void setJwtTokenProvider(JwtTokenProvider jwtTokenProvider) {
        this.jwtTokenProvider = jwtTokenProvider;
    }
}

