/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler.base;

import c8y.Command;
import c8y.ua.command.BaseRead;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.ValueAbnormalStatusCodeEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.ValueReadSuccessfulEvent;
import com.cumulocity.opcua.client.gateway.operation.exception.OperationExecutionException;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationHandler;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationNodeValidator;
import com.cumulocity.opcua.client.model.ReadConfig;
import com.cumulocity.opcua.client.model.ReadResult;
import com.cumulocity.opcua.client.serialization.OpcuaSerializer;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public abstract class ReadOperationHandler<T extends BaseRead>
extends UAOperationHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(ReadOperationHandler.class);
    private final OpcuaSerializer serializer;
    private final ApplicationEventPublisher eventPublisher;

    public ReadOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, Class<T> supportedOperationType, DeviceControlApi deviceControlApi, OpcuaSerializer serializer, ApplicationEventPublisher eventPublisher, InventoryApi inventoryApi, UAOperationNodeValidator nodeValidator) {
        super(gatewayManager, connectionManager, supportedOperationType, deviceControlApi, inventoryApi, nodeValidator);
        this.serializer = serializer;
        this.eventPublisher = eventPublisher;
    }

    protected HandleInternalResult handleInternal(T operation) throws OperationExecutionException {
        Optional clientOptional = this.resolveClient(operation);
        if (!clientOptional.isPresent()) {
            throw new OperationExecutionException("UA Server is not resolvable / not connected!");
        }
        OpcuaClient client = (OpcuaClient)clientOptional.get();
        ReadConfig readConfig = this.getReadConfig(operation, client);
        readConfig.setMaxAge(operation.getMaxAge());
        readConfig.setTimestampsToReturn(TimestampsToReturn.valueOf((String)operation.getTimestampsToReturn()));
        try {
            ReadResult result = client.read(readConfig);
            Command cmd = new Command();
            cmd.setResult(this.serializer.toJson((Object)result));
            boolean anyFailed = false;
            String failureReason = null;
            Optional opcuaServerId = this.getOPCUAServerId(operation);
            if (!opcuaServerId.isPresent()) {
                throw new OperationExecutionException("OPCUA Server ID is not present!");
            }
            Map results = result.getResults();
            for (Map.Entry nodeEntry : results.entrySet()) {
                for (Map.Entry attributeEntry : ((Map)nodeEntry.getValue()).entrySet()) {
                    ValueReadSuccessfulEvent event;
                    if (((DataValue)attributeEntry.getValue()).getStatusCode() != StatusCode.GOOD) {
                        anyFailed = true;
                        failureReason = ((DataValue)attributeEntry.getValue()).getStatusCode().toString();
                        event = new ValueAbnormalStatusCodeEvent((String)opcuaServerId.get(), ((NodeId)nodeEntry.getKey()).toString(), (DataValue)attributeEntry.getValue());
                        this.eventPublisher.publishEvent((Object)event);
                        break;
                    }
                    if (!Attributes.Value.equals(attributeEntry.getKey())) continue;
                    event = new ValueReadSuccessfulEvent((String)opcuaServerId.get(), ((NodeId)nodeEntry.getKey()).toString(), (DataValue)attributeEntry.getValue());
                    log.debug("Publishing ValueReadSuccessfulEvent: " + event);
                    this.eventPublisher.publishEvent((Object)event);
                }
                if (!anyFailed) continue;
                break;
            }
            return new HandleInternalResult(cmd, !anyFailed, failureReason);
        }
        catch (OpcuaClientException e) {
            throw new OperationExecutionException((Throwable)e);
        }
    }

    protected abstract ReadConfig getReadConfig(T var1, OpcuaClient var2);
}

