/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler.base;

import c8y.Command;
import c8y.ua.command.BaseOperation;
import c8y.ua.command.ExpiringOperation;
import c8y.ua.data.DeviceTypeMappedNode;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.model.operation.OperationStatus;
import com.cumulocity.model.util.ExtensibilityConverter;
import com.cumulocity.opcua.client.gateway.operation.exception.OperationExecutionException;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.serialization.OpcuaSerializer;
import com.cumulocity.rest.representation.operation.OperationRepresentation;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class OperationHandler<T extends BaseOperation> {
    private static final Logger log = LoggerFactory.getLogger(OperationHandler.class);
    private static final String EXPIRED_FAILURE_MESSAGE = "Operation expired";
    private static final String EXPIRATION_NOT_SUPPORTED = "Expiration not supported for this operation type";
    protected final DeviceControlApi deviceControlApi;
    protected final Class<T> supportedOperationType;
    private boolean printErrorTrace = true;

    protected static String toJSON(Collection<DeviceTypeMappedNode> foundNodes) {
        return OpcuaSerializer.getInstance().toJson(foundNodes);
    }

    protected abstract HandleInternalResult handleInternal(T var1) throws OperationExecutionException;

    public boolean supports(OperationRepresentation operationRepresentation) {
        return operationRepresentation.hasProperty(ExtensibilityConverter.classToStringRepresentation((Class)this.supportedOperationType));
    }

    public void handle(BaseOperation operation) {
        if (!this.supportedOperationType.isAssignableFrom(operation.getClass())) {
            return;
        }
        if (this.isExpiringOperationType(operation) && this.isOperationExpired(operation)) {
            log.info("Operation {} is expired.", (Object)operation.getOperationId());
            this.setOperationAsFailed(operation.getOperationId(), EXPIRED_FAILURE_MESSAGE, null);
            return;
        }
        if (!this.isExpiringOperationType(operation) && Objects.nonNull(operation.getExpirationTime())) {
            log.warn("Expiration time was given for operation {}, but type {} does not support expiration", (Object)operation.getOperationId(), (Object)operation.getClass().getCanonicalName());
            this.setOperationAsFailed(operation.getOperationId(), EXPIRATION_NOT_SUPPORTED, null);
            return;
        }
        log.info("Handling operation: {}", (Object)operation);
        if (operation.isTimeConsumingOperation()) {
            this.setOperationAsExecuting(operation.getOperationId());
        }
        try {
            HandleInternalResult result = this.handleInternal(operation);
            if (result.isSuccessful()) {
                this.setOperationAsSuccessful(operation.getOperationId(), result.getCommand());
            } else {
                this.setOperationAsFailed(operation.getOperationId(), result.getFailureReason(), result.getCommand());
            }
        }
        catch (Exception ex) {
            if (this.printErrorTrace) {
                log.error("Error handling operation from event: {}", (Object)operation, (Object)ex);
            }
            this.setOperationAsFailed(operation.getOperationId(), "Internal error: " + ex.getMessage(), null);
        }
    }

    private void updateOperation(GId operationId, OperationStatus status, String failureReason, Command cmd) {
        try {
            log.debug("Updating operation status: " + operationId + ": " + status);
            OperationRepresentation operationRepresentation = new OperationRepresentation();
            operationRepresentation.setId(operationId);
            operationRepresentation.setStatus(status.name());
            operationRepresentation.setFailureReason(failureReason);
            if (cmd != null) {
                operationRepresentation.set((Object)cmd);
            }
            OperationRepresentation update = this.deviceControlApi.update(operationRepresentation);
            log.debug("Updated: " + update);
        }
        catch (RuntimeException e) {
            log.error("Error updating operation!", (Throwable)e);
            throw e;
        }
    }

    private void setOperationAsExecuting(GId operationId) {
        this.updateOperation(operationId, OperationStatus.EXECUTING, null, null);
    }

    private void setOperationAsSuccessful(GId operationId, Command cmd) {
        this.updateOperation(operationId, OperationStatus.SUCCESSFUL, null, cmd);
    }

    protected void setOperationAsFailed(GId operationId, String reason, Command cmd) {
        log.warn("Operation: {} has failed with reason: {}", (Object)operationId.getValue(), (Object)reason);
        this.updateOperation(operationId, OperationStatus.FAILED, reason, cmd);
    }

    protected boolean isExpiringOperationType(BaseOperation operation) {
        return operation.getClass().isAnnotationPresent(ExpiringOperation.class);
    }

    protected boolean isOperationExpired(BaseOperation operation) {
        if (Objects.isNull(operation.getExpirationTime())) {
            log.debug("No expiration time given for operation {} -> not expired", (Object)operation.getOperationId());
            return false;
        }
        return operation.getExpirationTime().isBeforeNow();
    }

    @Autowired
    public OperationHandler(DeviceControlApi deviceControlApi, Class<T> supportedOperationType) {
        this.deviceControlApi = deviceControlApi;
        this.supportedOperationType = supportedOperationType;
    }

    public Class<T> getSupportedOperationType() {
        return this.supportedOperationType;
    }

    public void setPrintErrorTrace(boolean printErrorTrace) {
        this.printErrorTrace = printErrorTrace;
    }
}

