/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler;

import c8y.ua.command.ReadFileOperation;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.operation.handler.base.BaseReadAndUploadFileOperationHandler;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationNodeValidator;
import com.cumulocity.opcua.client.gateway.platform.repository.BinariesRepository;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReadAndUploadFileToBinaryRepoOperationHandler
extends BaseReadAndUploadFileOperationHandler<ReadFileOperation> {
    private static final Logger log = LoggerFactory.getLogger(ReadAndUploadFileToBinaryRepoOperationHandler.class);
    private static final String OPCUA_FILE_TYPE = "ua-file-type";
    private final BinariesRepository binariesRepository;

    @Autowired
    public ReadAndUploadFileToBinaryRepoOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, DeviceControlApi deviceControlApi, BinariesRepository binariesRepository, InventoryApi inventoryApi, UAOperationNodeValidator nodeValidator) {
        super(gatewayManager, connectionManager, ReadFileOperation.class, deviceControlApi, inventoryApi, nodeValidator);
        this.binariesRepository = binariesRepository;
    }

    protected void uploadFile(ReadFileOperation operation, Path localFilePath) throws IOException {
        log.info("Uploading file: {}", (Object)operation.getFileNodeId());
        ManagedObjectRepresentation wrapper = new ManagedObjectRepresentation();
        wrapper.setType(OPCUA_FILE_TYPE);
        wrapper.setName(operation.getFileNodeId());
        this.binariesRepository.uploadFile(wrapper, Files.newInputStream(localFilePath, new OpenOption[0]));
        Files.deleteIfExists(localFilePath);
    }
}

