/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler;

import c8y.Command;
import c8y.ua.command.BaseOperation;
import c8y.ua.command.ProcessMappingsForDeviceValues;
import c8y.ua.data.DeviceTypeMappedNode;
import c8y.ua.data.DeviceTypeMappedNodeCollection;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.addressspace.service.AddressSpaceDataStoreService;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.mappings.DeviceTypeRepository;
import com.cumulocity.opcua.client.gateway.mappings.ServerMappingsRepository;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.ValueAbnormalStatusCodeEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.ValueReadSuccessfulEvent;
import com.cumulocity.opcua.client.gateway.operation.exception.OperationExecutionException;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationHandler;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationNodeValidator;
import com.cumulocity.opcua.client.model.ReadConfig;
import com.cumulocity.opcua.client.model.ReadResult;
import com.cumulocity.opcua.client.serialization.OpcuaSerializer;
import com.cumulocity.opcua.common.DeviceExternalId;
import com.cumulocity.rest.representation.identity.ExternalIDRepresentation;
import com.cumulocity.sdk.client.QueryParam;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.identity.ExternalIDCollection;
import com.cumulocity.sdk.client.identity.IdentityApi;
import com.cumulocity.sdk.client.identity.PagedExternalIDCollectionRepresentation;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class ProcessMappingsForDeviceValuesOperationHandler
extends UAOperationHandler<ProcessMappingsForDeviceValues> {
    private static final Logger log = LoggerFactory.getLogger(ProcessMappingsForDeviceValuesOperationHandler.class);
    private final DeviceTypeRepository deviceTypeRepository;
    protected final AddressSpaceDataStoreService addressSpaceDataStoreService;
    private final IdentityApi identityApi;
    private final ApplicationEventPublisher eventPublisher;
    private final ServerMappingsRepository serverMappingsRepository;

    @Autowired
    public ProcessMappingsForDeviceValuesOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, DeviceControlApi deviceControlApi, OpcuaSerializer serializer, ApplicationEventPublisher eventPublisher, InventoryApi inventoryApi, UAOperationNodeValidator nodeValidator, DeviceTypeRepository deviceTypeRepository, AddressSpaceDataStoreService addressSpaceDataStoreService, IdentityApi identityApi, ServerMappingsRepository serverMappingsRepository) {
        super(gatewayManager, connectionManager, ProcessMappingsForDeviceValues.class, deviceControlApi, inventoryApi, nodeValidator);
        this.deviceTypeRepository = deviceTypeRepository;
        this.addressSpaceDataStoreService = addressSpaceDataStoreService;
        this.identityApi = identityApi;
        this.eventPublisher = eventPublisher;
        this.serverMappingsRepository = serverMappingsRepository;
    }

    protected HandleInternalResult handleInternal(ProcessMappingsForDeviceValues operation) throws OperationExecutionException {
        Optional connection = this.connectionManager.getConnection(new ServerIdentifier(operation.getDeviceId()));
        if (connection.isPresent()) {
            return new HandleInternalResult(null, false, "Operation is not allowed for OPC UA Server!");
        }
        ReadResult result = this.readValues(operation);
        Optional opcuaServerId = this.getOPCUAServerId((BaseOperation)operation);
        if (!opcuaServerId.isPresent()) {
            throw new OperationExecutionException("OPCUA Server ID is not present!");
        }
        boolean anyFailed = false;
        HashMap<String, String> cmdResultMap = new HashMap<String, String>();
        HashMap<String, String> failureReasonMap = new HashMap<String, String>();
        Map results = result.getResults();
        for (Map.Entry nodeEntry : results.entrySet()) {
            for (Map.Entry attributeEntry : ((Map)nodeEntry.getValue()).entrySet()) {
                ValueAbnormalStatusCodeEvent event;
                if (((DataValue)attributeEntry.getValue()).getStatusCode() != StatusCode.GOOD) {
                    event = new ValueAbnormalStatusCodeEvent((String)opcuaServerId.get(), ((NodeId)nodeEntry.getKey()).toString(), (DataValue)attributeEntry.getValue());
                    log.debug("Publishing ValueAbnormalStatusCodeEvent: " + event);
                    this.eventPublisher.publishEvent((Object)event);
                    anyFailed = true;
                    failureReasonMap.put(((NodeId)nodeEntry.getKey()).toString(), ((DataValue)attributeEntry.getValue()).getStatusCode().toString());
                    cmdResultMap.put(((NodeId)nodeEntry.getKey()).toString(), ((DataValue)attributeEntry.getValue()).getStatusCode().getName());
                    continue;
                }
                if (!Attributes.Value.equals(attributeEntry.getKey())) continue;
                event = new ValueReadSuccessfulEvent((String)opcuaServerId.get(), ((NodeId)nodeEntry.getKey()).toString(), (DataValue)attributeEntry.getValue());
                log.debug("Publishing ValueReadSuccessfulEvent: " + (ValueReadSuccessfulEvent)event);
                this.eventPublisher.publishEvent((Object)event);
                cmdResultMap.put(((NodeId)nodeEntry.getKey()).toString(), ((DataValue)attributeEntry.getValue()).getStatusCode().getName());
            }
        }
        Command cmd = this.createCommand(cmdResultMap);
        String failureReason = this.createFailureReason(failureReasonMap);
        return new HandleInternalResult(cmd, !anyFailed, failureReason);
    }

    protected Command createCommand(Map<String, String> cmdResult) {
        Command cmd = new Command();
        if (cmdResult.isEmpty()) {
            cmd.setResult("Read 0 node(s)");
            return cmd;
        }
        StringBuilder resultBuilder = new StringBuilder();
        resultBuilder.append("Read ").append(cmdResult.size()).append(" node(s), Details: ");
        cmdResult.forEach((key, value) -> resultBuilder.append((String)key).append("(").append((String)value).append("), "));
        if (resultBuilder.toString().endsWith(", ")) {
            resultBuilder.setLength(resultBuilder.length() - 2);
        }
        cmd.setResult(resultBuilder.toString());
        return cmd;
    }

    protected String createFailureReason(Map<String, String> failureReasonMap) {
        if (failureReasonMap.isEmpty()) {
            return null;
        }
        StringBuilder failureReasonBuilder = new StringBuilder();
        failureReasonBuilder.append("Read failed and skipped for " + failureReasonMap.size() + " node(s), Details:  ");
        failureReasonMap.forEach((key, value) -> failureReasonBuilder.append("NodeId: ").append((String)key).append(" Status: ").append((String)value).append(", "));
        if (failureReasonBuilder.toString().endsWith(", ")) {
            failureReasonBuilder.setLength(failureReasonBuilder.length() - 2);
        }
        return failureReasonBuilder.toString();
    }

    protected ReadResult readValues(ProcessMappingsForDeviceValues operation) throws OperationExecutionException {
        Optional clientOptional = this.resolveClient((BaseOperation)operation);
        if (!clientOptional.isPresent()) {
            throw new OperationExecutionException("UA Server is not resolvable / not connected!");
        }
        OpcuaClient client = (OpcuaClient)clientOptional.get();
        ReadConfig readConfig = ReadConfig.attributeOfNodes((UnsignedInteger)UnsignedInteger.parseUnsignedInteger((String)operation.getAttribute()), null, (String[])this.getQueryNodes(operation).toArray(new String[0]));
        readConfig.setMaxAge(operation.getMaxAge());
        readConfig.setTimestampsToReturn(TimestampsToReturn.valueOf((String)operation.getTimestampsToReturn()));
        try {
            return client.read(readConfig);
        }
        catch (OpcuaClientException e) {
            throw new OperationExecutionException((Throwable)e);
        }
    }

    protected Set<String> getQueryNodes(ProcessMappingsForDeviceValues operation) {
        ExternalIDRepresentation externalId = this.getOPCUADeviceExternalIdRepresentation(operation.getDeviceId());
        if (externalId == null || externalId.getExternalId() == null) {
            log.warn("No c8y_OpcuaDevice external id found for device: " + operation.getDeviceId().getValue());
            return new HashSet<String>();
        }
        String deviceTypeId = null;
        DeviceExternalId deviceExternalId = new DeviceExternalId(externalId.getExternalId());
        try {
            deviceTypeId = deviceExternalId.getDeviceTypeId();
        }
        catch (Exception e) {
            log.error("Error while parsing external id: " + externalId.getExternalId(), (Throwable)e);
        }
        if (deviceTypeId == null) {
            log.warn("No device type found for device: " + operation.getDeviceId().getValue());
            return new HashSet<String>();
        }
        HashSet<String> nodeSet = new HashSet<String>();
        Optional opcuaServerId = this.getOPCUAServerId((BaseOperation)operation);
        if (!opcuaServerId.isPresent()) {
            log.warn("OPCUA Server ID is not present!");
            return new HashSet<String>();
        }
        DeviceTypeMappedNodeCollection serverMappedNodes = this.serverMappingsRepository.getServerMappedNodes((String)opcuaServerId.get());
        for (DeviceTypeMappedNode mapping : serverMappedNodes.getMappings()) {
            if (!mapping.getDeviceTypeId().equals(deviceTypeId)) continue;
            mapping.getMappedTargetNodes().forEach(mappedTargetNode -> nodeSet.add(mappedTargetNode.getTargetNodeId()));
        }
        return nodeSet;
    }

    protected ExternalIDRepresentation getOPCUADeviceExternalIdRepresentation(GId operationDeviceId) {
        ExternalIDCollection externalIDCollection = this.identityApi.getExternalIdsOfGlobalId(operationDeviceId);
        PagedExternalIDCollectionRepresentation pagedExternalIDCollectionRepresentation = (PagedExternalIDCollectionRepresentation)externalIDCollection.get(new QueryParam[0]);
        return pagedExternalIDCollectionRepresentation.getExternalIds().stream().filter(externalID -> externalID.getType().equals("c8y_OpcuaDevice")).findFirst().orElse(null);
    }
}

