/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation;

import c8y.ua.ClientConfig;
import c8y.ua.command.ScanAddressSpace;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.model.operation.OperationStatus;
import com.cumulocity.opcua.client.NodeIds;
import com.cumulocity.opcua.client.gateway.addressspace.service.AddressSpaceScanEvaluationService;
import com.cumulocity.opcua.client.gateway.connection.model.ServerConnectedEvent;
import com.cumulocity.opcua.client.gateway.connection.model.ServerDisconnectedEvent;
import com.cumulocity.opcua.client.gateway.operation.OperationExecutor;
import com.cumulocity.rest.representation.operation.OperationRepresentation;
import com.cumulocity.sdk.client.QueryParam;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.devicecontrol.OperationFilter;
import com.cumulocity.sdk.client.devicecontrol.PagedOperationCollectionRepresentation;
import com.prosysopc.ua.stack.core.Identifiers;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronSequenceGenerator;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@Component
public class OperationScheduler {
    private static final Logger log = LoggerFactory.getLogger(OperationScheduler.class);
    private final DeviceControlApi deviceControlApi;
    private final OperationExecutor operationExecutor;
    private final TaskScheduler taskScheduler;
    private final AddressSpaceScanEvaluationService addressSpaceScanEvaluationService;
    private final Map<GId, ScheduledFuture<?>> scheduledOperations = new ConcurrentHashMap();

    public void scheduleSelfOperations(ServerConnectedEvent serverConnectedEvent) {
        GId serverMOId = serverConnectedEvent.getServerIdentifier().getInventoryIdentifier();
        ClientConfig clientConfig = serverConnectedEvent.getClientConfig();
        if (this.addressSpaceScanEvaluationService.isAutoAddressSpaceScanEnabled(serverMOId.getValue())) {
            this.createInitialOperationsIfNeeded(serverMOId, clientConfig);
        }
        this.schedulePeriodicallyOperations(serverMOId, clientConfig);
    }

    public void cancelScheduledOperations(ServerDisconnectedEvent serverDisconnectedEvent) {
        GId serverMOId = serverDisconnectedEvent.getServerIdentifier().getInventoryIdentifier();
        this.cancelInternal(serverMOId);
    }

    public void reschedule(GId serverMOId, ClientConfig clientConfig) {
        this.cancelInternal(serverMOId);
        this.schedulePeriodicallyOperations(serverMOId, clientConfig);
    }

    private void cancelInternal(GId serverMOId) {
        if (this.scheduledOperations.containsKey(serverMOId)) {
            log.info("Cancelling scheduled operation for server: {}", (Object)serverMOId.getValue());
            ((ScheduledFuture)this.scheduledOperations.remove(serverMOId)).cancel(true);
        }
    }

    private void createInitialOperationsIfNeeded(GId serverMOId, ClientConfig clientConfig) {
        boolean scanAddressSpaceExists = this.isScanAddressSpaceOperationExisted(serverMOId, OperationStatus.SUCCESSFUL);
        if (!scanAddressSpaceExists) {
            scanAddressSpaceExists = this.isScanAddressSpaceOperationExisted(serverMOId, OperationStatus.PENDING);
        }
        if (!scanAddressSpaceExists) {
            this.createScanAddressSpaceOperation(serverMOId, clientConfig);
        }
    }

    private boolean isScanAddressSpaceOperationExisted(GId source, OperationStatus status) {
        OperationFilter successfulOperationFilter = new OperationFilter().byDevice(source.getValue()).byFragmentType(ScanAddressSpace.class).byStatus(status);
        List operations = ((PagedOperationCollectionRepresentation)this.deviceControlApi.getOperationsByFilter(successfulOperationFilter).get(1, new QueryParam[0])).getOperations();
        return !operations.isEmpty();
    }

    private void schedulePeriodicallyOperations(GId serverMOId, ClientConfig clientConfig) {
        if (!StringUtils.isEmpty((CharSequence)clientConfig.getRescanCron())) {
            Date nextFire;
            try {
                nextFire = new CronSequenceGenerator(clientConfig.getRescanCron()).next(new Date());
            }
            catch (Exception e) {
                log.error("Provided cron expression is not valid: {}", (Object)clientConfig.getRescanCron());
                return;
            }
            CronTrigger cronTrigger = new CronTrigger(clientConfig.getRescanCron());
            log.info("Scheduling addressSpace scan of server: {} with cron expression: {}, next fire: {}", new Object[]{serverMOId, clientConfig.getRescanCron(), nextFire});
            ScheduledFuture scheduled = this.taskScheduler.schedule(this.createOperationIfNeeded(serverMOId, clientConfig), (Trigger)cronTrigger);
            this.scheduledOperations.put(serverMOId, scheduled);
        }
    }

    private Runnable createOperationIfNeeded(GId serverMOId, ClientConfig clientConfig) {
        return () -> {
            Date nextFire = new CronSequenceGenerator(clientConfig.getRescanCron()).next(new Date());
            if (!this.isPendingOperationExisted(serverMOId)) {
                this.createScanAddressSpaceOperation(serverMOId, clientConfig);
                log.info("Scheduled periodically scan address space of server: {}, next fire: {}", (Object)serverMOId, (Object)nextFire);
            } else {
                log.info("There is still a pending full address space scanning operation, skip this fire. Next attempt at: {}", (Object)nextFire);
            }
        };
    }

    private boolean isPendingOperationExisted(GId serverMOId) {
        OperationFilter operationFilter = new OperationFilter().byStatus(OperationStatus.PENDING).byDevice(serverMOId.getValue()).byFragmentType(ScanAddressSpace.class);
        List operations = ((PagedOperationCollectionRepresentation)this.deviceControlApi.getOperationsByFilter(operationFilter).get(1, new QueryParam[0])).getOperations();
        return !operations.isEmpty() && operations.stream().anyMatch(operation -> {
            ScanAddressSpace scanAddressSpace = (ScanAddressSpace)operation.get(ScanAddressSpace.class);
            return !Objects.isNull(scanAddressSpace) && (CollectionUtils.isEmpty((Collection)scanAddressSpace.getNodeIds()) || scanAddressSpace.getNodeIds().stream().anyMatch(n -> NodeIds.parseNodeId((String)n).equals((Object)Identifiers.RootFolder)));
        });
    }

    private void createScanAddressSpaceOperation(GId serverMOId, ClientConfig config) {
        OperationRepresentation scanAddressSpace = new OperationRepresentation();
        scanAddressSpace.setDeviceId(serverMOId);
        scanAddressSpace.set((Object)"[AUTO] Address space import from Root node", "description");
        ScanAddressSpace spaceScan = new ScanAddressSpace();
        if (Boolean.TRUE.equals(config.getPartialAddressScan()) && !CollectionUtils.isEmpty((Collection)config.getPartialAddressScanNodeIds())) {
            String ids = String.join((CharSequence)",", config.getPartialAddressScanNodeIds());
            scanAddressSpace.set((Object)("[AUTO] Address space import from node[s] " + ids), "description");
            spaceScan.setNodeIds(config.getPartialAddressScanNodeIds());
        }
        scanAddressSpace.set((Object)spaceScan);
        OperationRepresentation createdOperation = this.deviceControlApi.create(scanAddressSpace);
        this.operationExecutor.submit(createdOperation);
    }

    @Autowired
    public OperationScheduler(DeviceControlApi deviceControlApi, OperationExecutor operationExecutor, TaskScheduler taskScheduler, AddressSpaceScanEvaluationService addressSpaceScanEvaluationService) {
        this.deviceControlApi = deviceControlApi;
        this.operationExecutor = operationExecutor;
        this.taskScheduler = taskScheduler;
        this.addressSpaceScanEvaluationService = addressSpaceScanEvaluationService;
    }
}

