/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.tasks;

import com.cumulocity.model.event.CumulocitySeverities;
import com.cumulocity.opcua.client.gateway.mappingsexecution.exception.InvalidDataTypeException;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.BaseDataValueEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.BaseTask;
import com.cumulocity.opcua.client.gateway.platform.repository.ThinEdgeAlarmRepository;
import com.cumulocity.opcua.common.model.mapping.action.MeasurementCreation;
import com.cumulocity.opcua.common.validation.ValueLimitsValidator;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ThinEdgeMeasurementCreationTask
extends BaseTask {
    private static final Logger log = LoggerFactory.getLogger(ThinEdgeMeasurementCreationTask.class);
    MeasurementCreation measurementCreation;
    @Autowired
    private MqttClient mqttClient;
    @Autowired
    private ThinEdgeAlarmRepository alarmRepository;

    public void run() {
        try {
            if (this.isDataValueBad()) {
                return;
            }
            BaseDataValueEvent event = this.getEvent();
            BigDecimal value = this.extractValue(event);
            if (Objects.isNull(value)) {
                return;
            }
            Map measurement = this.buildThinEdgeMeasurement(event, value);
            String topic = "te/device/" + this.getSource().getId().getValue() + "///m/" + this.measurementCreation.getType();
            Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
            MqttMessage message = new MqttMessage();
            message.setPayload(gson.toJson((Object)measurement).getBytes());
            this.mqttClient.publish(topic, message);
        }
        catch (MqttException e) {
            this.alarmRepository.create(this.getDeviceId(), "opcuaMqttPublishFailed", CumulocitySeverities.MAJOR.name(), "Failed to publish MQTT message: " + e.getMessage());
            log.error("Failed to publish MQTT message: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private Map<String, Object> buildThinEdgeMeasurement(BaseDataValueEvent event, BigDecimal value) {
        HashMap<String, Object> measurement = new HashMap<String, Object>();
        measurement.put("time", this.getDateTimeWithFallBack(event).toString());
        HashMap<String, BigDecimal> measurementFragment = new HashMap<String, BigDecimal>();
        String measurementSeriesName = this.measurementCreation.getSeriesName(event.getNodeId());
        measurementFragment.put(measurementSeriesName, value);
        measurement.put(this.measurementCreation.getFragmentName(), measurementFragment);
        return measurement;
    }

    private BigDecimal extractValue(BaseDataValueEvent event) {
        log.debug("Creating measurement for " + event.getServerId() + ":" + event.getNodeId() + " ## " + this.measurementCreation);
        try {
            return ValueLimitsValidator.readNumericValue((Object)event.getValue().getValue().getValue());
        }
        catch (NumberFormatException e) {
            String errorMessage = "Invalid data type in OPC-UA measurement mapping:\n  nodeId: " + this.getEvent().getNodeId() + "\n  serverId: " + this.getEvent().getServerId() + "\n  received type: " + event.getValue().getClass().getName() + "\n  received value string: " + event.getValue().toString();
            this.alarmRepository.create(this.getDeviceId(), "opcuaInvalidMappingDataType", CumulocitySeverities.MAJOR.name(), errorMessage);
            throw new InvalidDataTypeException("Couldn't parse " + event.getValue().toString() + " to BigDecimal");
        }
    }

    public void setMeasurementCreation(MeasurementCreation measurementCreation) {
        this.measurementCreation = measurementCreation;
    }

    public void setMqttClient(MqttClient mqttClient) {
        this.mqttClient = mqttClient;
    }

    public void setAlarmRepository(ThinEdgeAlarmRepository alarmRepository) {
        this.alarmRepository = alarmRepository;
    }
}

