/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.tasks;

import com.cumulocity.model.event.CumulocitySeverities;
import com.cumulocity.opcua.client.gateway.mappingsexecution.exception.InvalidDataTypeException;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.BaseDataValueEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.BaseTask;
import com.cumulocity.opcua.client.gateway.platform.repository.ThinEdgeAlarmRepository;
import com.cumulocity.opcua.common.model.mapping.action.AlarmCreation;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Scope(value="prototype")
public class ThinEdgeAlarmCreationTask
extends BaseTask {
    private static final Logger log = LoggerFactory.getLogger(ThinEdgeAlarmCreationTask.class);
    private AlarmCreation alarmCreation;
    @Autowired
    private MqttClient mqttClient;
    @Autowired
    private ThinEdgeAlarmRepository alarmRepository;

    public void run() {
        try {
            BaseDataValueEvent event = this.getEvent();
            if (this.isDataValueBad()) {
                return;
            }
            log.debug("Creating alarm for " + event.getServerId() + ":" + event.getNodeId() + " ## " + this.alarmCreation);
            boolean active = this.getBooleanValue(event.getValue());
            String topic = "te/device/" + this.getSource().getId().getValue() + "///a/" + this.alarmCreation.getType();
            MqttMessage message = new MqttMessage();
            if (active) {
                Gson gson = new GsonBuilder().create();
                message.setPayload(gson.toJson((Object)this.buildThinEdgeAlarm(event)).getBytes());
            } else {
                message.setRetained(true);
            }
            this.mqttClient.publish(topic, message);
        }
        catch (MqttException e) {
            this.alarmRepository.create(this.getDeviceId(), "opcuaMqttPublishFailed", CumulocitySeverities.MAJOR.name(), "Failed to publish MQTT message: " + e.getMessage());
            log.error("Failed to publish MQTT message: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private Map<String, Object> buildThinEdgeAlarm(BaseDataValueEvent event) {
        HashMap<String, Object> teAlarm = new HashMap<String, Object>();
        teAlarm.put("time", this.getDateTimeWithFallBack(event).toString());
        teAlarm.put("text", this.alarmCreation.getText());
        teAlarm.put("severity", this.alarmCreation.getSeverity());
        teAlarm.put("c8y_ua_SourceNodeId_" + event.getNodeId(), new HashMap());
        if (!CollectionUtils.isEmpty((Collection)this.alarmCreation.getStaticFragments())) {
            this.alarmCreation.getStaticFragments().forEach(fragment -> teAlarm.put((String)fragment, Collections.emptyMap()));
        }
        return teAlarm;
    }

    boolean getBooleanValue(DataValue value) {
        Object obj = value.getValue().getValue();
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue() > 0;
        }
        if (obj instanceof String) {
            return Boolean.parseBoolean((String)obj);
        }
        String errorMessage = "Invalid data type in OPC-UA alarm mapping:\n  nodeId: " + this.getEvent().getNodeId() + "\n  serverId: " + this.getEvent().getServerId() + "\n  received type: " + obj.getClass().getName();
        this.alarmRepository.create(this.getDeviceId(), "opcuaInvalidMappingDataType", CumulocitySeverities.MAJOR.name(), errorMessage);
        throw new InvalidDataTypeException("Can't parse " + obj.getClass().getName() + " into boolean");
    }

    public void setAlarmCreation(AlarmCreation alarmCreation) {
        this.alarmCreation = alarmCreation;
    }

    public void setMqttClient(MqttClient mqttClient) {
        this.mqttClient = mqttClient;
    }

    public void setAlarmRepository(ThinEdgeAlarmRepository alarmRepository) {
        this.alarmRepository = alarmRepository;
    }
}

