/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.tasks;

import com.cumulocity.model.event.CumulocitySeverities;
import com.cumulocity.model.measurement.MeasurementValue;
import com.cumulocity.opcua.client.gateway.mappingsexecution.exception.InvalidDataTypeException;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.BaseDataValueEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.C8YBaseTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.TaskUtils;
import com.cumulocity.opcua.client.gateway.platform.repository.AlarmRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.BaseQueuedRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.MeasurementRepository;
import com.cumulocity.opcua.common.model.mapping.action.MappingAction;
import com.cumulocity.opcua.common.model.mapping.action.MeasurementCreation;
import com.cumulocity.opcua.common.validation.ValueLimitsValidator;
import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.rest.representation.measurement.MeasurementRepresentation;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class MeasurementCreationTask
extends C8YBaseTask<MeasurementRepresentation, List<MeasurementRepresentation>> {
    private static final Logger log = LoggerFactory.getLogger(MeasurementCreationTask.class);
    MeasurementCreation measurementCreation;
    @Autowired
    private MeasurementRepository measurementRepository;
    @Autowired
    private AlarmRepository alarmRepository;

    public void run() {
        BigDecimal value;
        BaseDataValueEvent event = this.getEvent();
        if (this.isDataValueBad()) {
            return;
        }
        log.debug("Creating measurement for " + event.getServerId() + ":" + event.getNodeId() + " ## " + this.measurementCreation);
        try {
            value = ValueLimitsValidator.readNumericValue((Object)event.getValue().getValue().getValue());
        }
        catch (NumberFormatException e) {
            String errorMessage = "Invalid data type in OPC-UA measurement mapping:\n  nodeId: " + this.getEvent().getNodeId() + "\n  serverId: " + this.getEvent().getServerId() + "\n  received type: " + event.getValue().getClass().getName() + "\n  received value string: " + event.getValue().toString();
            this.alarmRepository.create(this.getDeviceId(), "opcuaInvalidMappingDataType", CumulocitySeverities.MAJOR.name(), errorMessage);
            throw new InvalidDataTypeException("Couldn't parse " + event.getValue().toString() + " to BigDecimal");
        }
        if (Objects.isNull(value)) {
            return;
        }
        MeasurementRepresentation measurement = new MeasurementRepresentation();
        measurement.setSource(this.getSource());
        measurement.setDateTime(this.getDateTimeWithFallBack(event));
        measurement.setType(this.measurementCreation.getType());
        ManagedObjectRepresentation series = new ManagedObjectRepresentation();
        MeasurementValue mv = new MeasurementValue();
        mv.setUnit(this.measurementCreation.getUnit());
        mv.setValue(value);
        series.setProperty(this.measurementCreation.getSeriesName(event.getNodeId()), (Object)mv);
        measurement.setProperty(this.measurementCreation.getFragmentName(event.getNodeId()), (Object)series);
        measurement.setProperty("c8y_ua_SourceNodeId_" + event.getNodeId(), new HashMap());
        TaskUtils.populateStaticFragments((MappingAction)this.measurementCreation, (AbstractExtensibleRepresentation)measurement);
        this.addToQueue((AbstractExtensibleRepresentation)measurement);
    }

    protected BaseQueuedRepository<MeasurementRepresentation, List<MeasurementRepresentation>> getRepository() {
        return this.measurementRepository;
    }

    public void setMeasurementCreation(MeasurementCreation measurementCreation) {
        this.measurementCreation = measurementCreation;
    }

    public void setMeasurementRepository(MeasurementRepository measurementRepository) {
        this.measurementRepository = measurementRepository;
    }

    public void setAlarmRepository(AlarmRepository alarmRepository) {
        this.alarmRepository = alarmRepository;
    }
}

