/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.tasks;

import c8y.ua.data.C8YDataValue;
import com.cumulocity.model.event.CumulocitySeverities;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.BaseDataValueEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.C8YBaseTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.TaskUtils;
import com.cumulocity.opcua.client.gateway.platform.repository.AlarmRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.BaseQueuedRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.EventRepository;
import com.cumulocity.opcua.client.serialization.OpcuaSerializer;
import com.cumulocity.opcua.common.model.mapping.action.EventCreation;
import com.cumulocity.opcua.common.model.mapping.action.MappingAction;
import com.cumulocity.opcua.common.validation.ValueLimitsValidator;
import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import com.cumulocity.rest.representation.event.EventRepresentation;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.Variant;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.math.NumberUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class EventCreationTask
extends C8YBaseTask<EventRepresentation, EventRepresentation> {
    private static final Logger log = LoggerFactory.getLogger(EventCreationTask.class);
    static final Type MAP_TYPE = new /* Unavailable Anonymous Inner Class!! */.getType();
    private EventCreation eventCreation;
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private AlarmRepository alarmRepository;
    private ObjectMapper objectMapper = new ObjectMapper();

    public void run() {
        BaseDataValueEvent event = this.getEvent();
        if (this.isDataValueBad()) {
            return;
        }
        log.debug("Creating event for " + event.getServerId() + ":" + event.getNodeId() + " ## " + this.eventCreation);
        String valueAsString = this.getValueAsJsonString();
        EventRepresentation eventRepresentation = new EventRepresentation();
        eventRepresentation.setSource(this.getSource());
        eventRepresentation.setCreationDateTime(null);
        eventRepresentation.setType(this.eventCreation.getType());
        eventRepresentation.setText(this.eventCreation.getText().replaceAll("\\$\\{value}", valueAsString));
        eventRepresentation.setProperty("c8y_ua_SourceNodeId_" + event.getNodeId(), new HashMap());
        DateTime dateTime = this.getDateTimeWithFallBack(event);
        eventRepresentation.setDateTime(dateTime);
        try {
            this.populateEventValueFragment(eventRepresentation, event.getValue());
        }
        catch (JsonProcessingException jpe) {
            log.error("Cannot parse event value to JSON");
        }
        TaskUtils.populateStaticFragments((MappingAction)this.eventCreation, (AbstractExtensibleRepresentation)eventRepresentation);
        this.addToQueue((AbstractExtensibleRepresentation)eventRepresentation);
    }

    protected BaseQueuedRepository<EventRepresentation, EventRepresentation> getRepository() {
        return this.eventRepository;
    }

    private void populateEventValueFragment(EventRepresentation eventRepresentation, DataValue dataValue) throws JsonProcessingException {
        Long sourceTimestamp = TaskUtils.getTimeStampOrNull((com.prosysopc.ua.stack.builtintypes.DateTime)dataValue.getSourceTimestamp());
        Long serverTimestamp = TaskUtils.getTimeStampOrNull((com.prosysopc.ua.stack.builtintypes.DateTime)dataValue.getServerTimestamp());
        C8YDataValue c8YDataValue = C8YDataValue.builder().statusCode((long)dataValue.getStatusCode().getValue().intValue()).serverTimestamp(serverTimestamp).sourceTimestamp(sourceTimestamp).value(this.getVariantValueAsMap(dataValue.getValue())).build();
        eventRepresentation.set((Object)c8YDataValue);
    }

    public Map<String, Object> getVariantValueAsMap(Variant variant) throws JsonProcessingException {
        Variant variantToSerialize = variant;
        if (NumberUtils.isCreatable((String)variant.getValue().toString())) {
            try {
                BigDecimal value = ValueLimitsValidator.readNumericValue((Object)variant.getValue());
                log.trace("Server ID: {}, Node ID: {}, Received value type: {}, Received value: {}, BigDecimal value: {}", new Object[]{this.getEvent().getNodeId(), this.getEvent().getServerId(), this.getEvent().getValue().getClass(), this.getEvent().getValue(), value});
                variantToSerialize = new Variant((Object)value);
            }
            catch (NumberFormatException e) {
                String errorMessage = "Invalid data type in OPC-UA event mapping:\n  nodeId: " + this.getEvent().getNodeId() + "\n  serverId: " + this.getEvent().getServerId() + "\n  received type: " + variant.getValue().getClass().getName() + "\n  received value string: " + variant.getValue().toString();
                this.alarmRepository.create(this.getDeviceId(), "opcuaInvalidMappingDataType", CumulocitySeverities.MAJOR.name(), errorMessage);
            }
        }
        String variantValueAsString = OpcuaSerializer.getInstance().toJson((Object)variantToSerialize);
        return (Map)this.objectMapper.readValue(variantValueAsString, TreeMap.class);
    }

    public void setEventCreation(EventCreation eventCreation) {
        this.eventCreation = eventCreation;
    }

    public void setEventRepository(EventRepository eventRepository) {
        this.eventRepository = eventRepository;
    }

    public void setAlarmRepository(AlarmRepository alarmRepository) {
        this.alarmRepository = alarmRepository;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public EventCreation getEventCreation() {
        return this.eventCreation;
    }
}

