/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.tasks;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.BaseDataValueEvent;
import com.cumulocity.opcua.client.serialization.OpcuaSerializer;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import java.util.Objects;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(BaseTask.class);
    private GId deviceId;
    private BaseDataValueEvent event;

    BaseTask() {
    }

    ManagedObjectRepresentation getSource() {
        ManagedObjectRepresentation mo = new ManagedObjectRepresentation();
        mo.setId(this.deviceId);
        return mo;
    }

    String getValueAsJsonString() {
        DataValue dataValue = this.event.getValue();
        return OpcuaSerializer.getInstance().toJson((Object)dataValue);
    }

    boolean isDataValueBad() {
        DataValue dataValue = this.event.getValue();
        if (!this.isGoodStatus(this.event)) {
            log.warn("Status code of data value is not good, skipped value: {}/{} -> {}", new Object[]{this.event.getServerId(), this.event.getNodeId(), dataValue.getStatusCode()});
            return true;
        }
        if (this.isNullValueReceived(this.event)) {
            if (log.isDebugEnabled()) {
                log.debug("Null data value, skipped value: {}/{} -> {}", new Object[]{this.event.getServerId(), this.event.getNodeId(), dataValue.getValue()});
            }
            return true;
        }
        return false;
    }

    private boolean isGoodStatus(BaseDataValueEvent dataValueEvent) {
        return Objects.isNull(dataValueEvent.getValue().getStatusCode()) || dataValueEvent.getValue().getStatusCode().isGood();
    }

    private boolean isNullValueReceived(BaseDataValueEvent dataValueEvent) {
        return Objects.isNull(dataValueEvent.getValue().getValue()) || Objects.isNull(dataValueEvent.getValue().getValue().getValue());
    }

    protected DateTime getDateTimeWithFallBack(BaseDataValueEvent event) {
        if (Objects.nonNull(event.getValue().getSourceTimestamp())) {
            return new DateTime(event.getValue().getSourceTimestamp().getTimeInMillis());
        }
        if (Objects.nonNull(event.getValue().getServerTimestamp())) {
            return new DateTime(event.getValue().getServerTimestamp().getTimeInMillis());
        }
        return DateTime.now();
    }

    public GId getDeviceId() {
        return this.deviceId;
    }

    public BaseDataValueEvent getEvent() {
        return this.event;
    }

    public void setDeviceId(GId deviceId) {
        this.deviceId = deviceId;
    }

    public void setEvent(BaseDataValueEvent event) {
        this.event = event;
    }
}

