/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.model;

import com.cumulocity.opcua.common.model.mapping.action.HttpPostAction;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import org.springframework.util.CollectionUtils;

public class HttpPostElement {
    private final long sequence;
    private final String id;
    private final String endpoint;
    private final Map<String, String> headers;
    private final String requestBody;
    private final String serverId;
    private volatile Long lastTryAt;
    private volatile int retries;
    private final Boolean retryEnabled;
    private final Set<Long> noRetryHttpCodes;

    public HttpPostElement(long sequence, String serverId, String endPoint, Map<String, String> headers, String requestBody, Boolean retryEnabled, Set<Long> noRetryHttpCodes) {
        this.sequence = sequence;
        this.retryEnabled = retryEnabled;
        this.noRetryHttpCodes = noRetryHttpCodes;
        this.id = UUID.randomUUID().toString();
        this.endpoint = endPoint;
        this.headers = headers;
        this.requestBody = requestBody;
        this.serverId = serverId;
        this.retries = 0;
    }

    public static HttpPostElement fromAction(HttpPostAction action, String parsedRequestBody, String serverId, Long sequence) {
        return new HttpPostElement(sequence.longValue(), serverId, action.getEndpoint(), action.getHeaders(), parsedRequestBody, action.getRetryEnabled(), action.getNoRetryHttpCodes());
    }

    public boolean everRetried() {
        return this.retries > 0 && Objects.nonNull(this.lastTryAt);
    }

    public boolean shouldTryNow(int delayInSeconds) {
        if (Objects.isNull(this.lastTryAt)) {
            return true;
        }
        return this.lastTryAt + Duration.of(delayInSeconds, ChronoUnit.SECONDS).toMillis() <= System.currentTimeMillis();
    }

    public synchronized boolean markAsRetried(int maxRetries) {
        ++this.retries;
        this.lastTryAt = System.currentTimeMillis();
        return this.retries < maxRetries;
    }

    public String toString() {
        return new StringJoiner(", ", HttpPostElement.class.getSimpleName() + "[", "]").add("serverId='" + this.serverId + "'").add("endPoint='" + this.getEndpoint() + "'").add("headers=" + this.maskAuthorizationHeader()).add("httpEntity='" + this.getRequestBody() + "'").add("lastTryAt=" + this.lastTryAt).add("retries=" + this.retries).toString();
    }

    private Map<String, String> maskAuthorizationHeader() {
        if (CollectionUtils.isEmpty((Map)this.getHeaders())) {
            return this.getHeaders();
        }
        if (this.getHeaders().containsKey("Authorization")) {
            HashMap<String, String> result = new HashMap<String, String>(this.getHeaders());
            result.put("Authorization", "???");
            return result;
        }
        return this.getHeaders();
    }

    public long getSequence() {
        return this.sequence;
    }

    public String getId() {
        return this.id;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public String getServerId() {
        return this.serverId;
    }

    public Long getLastTryAt() {
        return this.lastTryAt;
    }

    public int getRetries() {
        return this.retries;
    }

    public Boolean getRetryEnabled() {
        return this.retryEnabled;
    }

    public Set<Long> getNoRetryHttpCodes() {
        return this.noRetryHttpCodes;
    }
}

