/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution;

import com.cumulocity.opcua.client.gateway.configuration.PlatformThinEdgeConfiguration;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MqttClientConfiguration {
    @Bean
    public MqttClient mqttClient(PlatformThinEdgeConfiguration config) throws MqttException {
        if (config != null && config.isUseForDataForwarding()) {
            MqttConnectOptions options = new MqttConnectOptions();
            options.setAutomaticReconnect(config.isMqttAutomaticReconnect());
            options.setCleanSession(config.isMqttCleanSession());
            options.setConnectionTimeout(config.getMqttConnectionTimeout());
            options.setKeepAliveInterval(config.getMqttKeepAliveInterval());
            options.setMaxInflight(config.getMqttMaxInFlight());
            MqttClient client = new MqttClient(config.getMqttServerUrl(), config.getThinEdgeDeviceId());
            client.connect(options);
            return client;
        }
        return null;
    }
}

