/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.history.model.HistoryValuesReadSuccessfulEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.BaseDataValueEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.BatchValueEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.ValueReadSuccessfulEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.MappingExecutionTaskFactory;
import com.cumulocity.opcua.client.gateway.subscription.model.DataChangedEvent;
import com.cumulocity.opcua.client.gateway.subscription.repository.SubscriptionRepository;
import com.cumulocity.opcua.common.model.mapping.ExecutableMappingAction;
import com.cumulocity.opcua.common.model.mapping.action.AlarmCreation;
import com.cumulocity.opcua.common.model.mapping.action.EventCreation;
import com.cumulocity.opcua.common.model.mapping.action.HttpPostAction;
import com.cumulocity.opcua.common.model.mapping.action.MappingAction;
import com.cumulocity.opcua.common.model.mapping.action.MeasurementCreation;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class MappingsExecutor {
    private static final Logger log = LoggerFactory.getLogger(MappingsExecutor.class);
    @Autowired
    private SubscriptionRepository subscriptionRepository;
    @Autowired
    private MappingExecutionTaskFactory factory;
    @Autowired
    @Qualifier(value="mappingsTaskExecutor")
    private TaskExecutor executor;

    public void onValueReadSuccessfulEvent(ValueReadSuccessfulEvent valueReadEvent) {
        log.debug("Processing value event: " + valueReadEvent);
        Collection mappings = valueReadEvent.getDeviceTypeId() != null && valueReadEvent.getRootNodeId() != null ? this.subscriptionRepository.getMappedActions(valueReadEvent.getServerId(), valueReadEvent.getNodeId(), valueReadEvent.getDeviceTypeId(), valueReadEvent.getRootNodeId()) : this.subscriptionRepository.getMappedActions(valueReadEvent.getServerId(), valueReadEvent.getNodeId());
        this.executeMappings((BaseDataValueEvent)valueReadEvent, mappings);
    }

    public void onValueDataChangedEvent(DataChangedEvent dataChangedEvent) {
        log.debug("Processing value event: " + dataChangedEvent);
        Collection mappings = this.subscriptionRepository.getMappedActions(dataChangedEvent.getServerId(), dataChangedEvent.getNodeId(), dataChangedEvent.getMonitoredItemId());
        this.executeMappings((BaseDataValueEvent)dataChangedEvent, mappings);
    }

    private void executeMappings(BaseDataValueEvent event, Collection<ExecutableMappingAction> mappings) {
        if (mappings.isEmpty() && log.isDebugEnabled()) {
            log.debug("No mappings found!");
        }
        for (ExecutableMappingAction mapping : mappings) {
            log.debug("Applying mapping " + mapping.getClass().getName());
            this.executor.execute(this.factory.create(mapping, event, GId.asGId((Object)mapping.getSourceDeviceId()), false));
        }
    }

    public void onBatchValueEvent(BatchValueEvent batchValueEvent) {
        log.debug("Processing batch values event: " + batchValueEvent);
        HashMap eventMappings = new HashMap();
        HashMap measurementMappings = new HashMap();
        HashMap customActionMappings = new HashMap();
        HashSet sourceDeviceIds = new HashSet();
        batchValueEvent.getValues().keySet().forEach(nodeId -> {
            if (batchValueEvent.getDeviceTypeId() != null && batchValueEvent.getRootNodeId() != null) {
                Collection singleMappings = this.subscriptionRepository.getMappedActions(batchValueEvent.getServerId(), nodeId, batchValueEvent.getDeviceTypeId(), batchValueEvent.getRootNodeId());
                singleMappings.stream().filter(mapping -> mapping.getMappingAction() instanceof AlarmCreation).forEach(mapping -> {
                    ValueReadSuccessfulEvent event = new ValueReadSuccessfulEvent(batchValueEvent.getServerId(), nodeId, (DataValue)batchValueEvent.getValues().get(nodeId), batchValueEvent.getDeviceTypeId(), batchValueEvent.getRootNodeId());
                    this.executor.execute(this.factory.create(mapping, (BaseDataValueEvent)event, GId.asGId((Object)mapping.getSourceDeviceId()), false));
                });
                List filteredForEventCreation = singleMappings.stream().filter(mapping -> mapping.getMappingAction() instanceof EventCreation).map(ExecutableMappingAction::getMappingAction).collect(Collectors.toList());
                if (!filteredForEventCreation.isEmpty()) {
                    eventMappings.put(nodeId, filteredForEventCreation);
                }
                List filteredForMeasurementCreation = singleMappings.stream().filter(mapping -> mapping.getMappingAction() instanceof MeasurementCreation).map(ExecutableMappingAction::getMappingAction).collect(Collectors.toList());
                measurementMappings.put(nodeId, filteredForMeasurementCreation);
                List filteredForCustomActionCreation = singleMappings.stream().filter(mapping -> mapping.getMappingAction() instanceof HttpPostAction).map(ExecutableMappingAction::getMappingAction).collect(Collectors.toList());
                customActionMappings.put(nodeId, filteredForCustomActionCreation);
                if (!singleMappings.isEmpty()) {
                    sourceDeviceIds.add(GId.asGId((Object)((ExecutableMappingAction)singleMappings.iterator().next()).getSourceDeviceId()));
                }
            }
        });
        if (!sourceDeviceIds.isEmpty() && !eventMappings.isEmpty()) {
            this.executor.execute(this.factory.createBatchForEvent(eventMappings, batchValueEvent, (GId)sourceDeviceIds.iterator().next()));
        }
        if (!sourceDeviceIds.isEmpty() && !measurementMappings.isEmpty()) {
            this.executor.execute(this.factory.createBatchForMeasurement(measurementMappings, batchValueEvent, (GId)sourceDeviceIds.iterator().next()));
        }
        if (!sourceDeviceIds.isEmpty() && !customActionMappings.isEmpty()) {
            this.executor.execute(this.factory.createBatchForCustomAction(customActionMappings, batchValueEvent, (GId)sourceDeviceIds.iterator().next()));
        }
    }

    public void onHistoryValuesReadSuccessfulEvent(HistoryValuesReadSuccessfulEvent event) {
        this.onHistoryDataArrived(event);
    }

    private void onHistoryDataArrived(HistoryValuesReadSuccessfulEvent event) {
        log.debug("Processing history value event: " + event);
        if (event.getValues() == null) {
            log.debug("No history value found");
            return;
        }
        Collection mappings = this.subscriptionRepository.getMappedActions(event.getServerId(), event.getNodeId());
        for (ExecutableMappingAction mapping : mappings) {
            MappingAction mappingAction = mapping.getMappingAction();
            if (mappingAction instanceof AlarmCreation) continue;
            for (DataValue value : event.getValues()) {
                if (value.getStatusCode().isGood()) {
                    ValueReadSuccessfulEvent dataValueEvent = new ValueReadSuccessfulEvent(event.getServerId(), event.getNodeId(), value);
                    log.debug("Applying historic mapping " + mapping.getClass().getName());
                    this.executor.execute(this.factory.createHistoric(mapping, event.getIsTaggingEnabled().booleanValue(), (BaseDataValueEvent)dataValueEvent, GId.asGId((Object)mapping.getSourceDeviceId())));
                    continue;
                }
                log.warn("There was a problem reading historic value: " + value + " Skipping this read.");
            }
        }
    }

    public int getActiveThreads() {
        return ((ThreadPoolTaskExecutor)this.executor).getActiveCount();
    }

    public int getQueuedThreads() {
        return ((ThreadPoolTaskExecutor)this.executor).getThreadPoolExecutor().getQueue().size();
    }
}

