/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappings;

import c8y.ua.data.DeviceTypeMappedNode;
import c8y.ua.data.DeviceTypeMappedNodeCollection;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.Nodes;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.configuration.InventoryUpdateProcessingModeConfiguration;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.connection.model.AddressSpaceUpdatedEvent;
import com.cumulocity.opcua.client.gateway.exception.ServerNotConnectedException;
import com.cumulocity.opcua.client.gateway.mappings.DeviceTypeMatchingService;
import com.cumulocity.opcua.client.gateway.mappings.DeviceTypeRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.MappedNodesRepository;
import com.cumulocity.opcua.client.gateway.subscription.model.DeviceTypeFetchedItems;
import com.cumulocity.opcua.common.repository.InventoryRepository;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.prosysopc.ua.stack.common.NamespaceTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ServerMappingsRepository {
    private static final Logger log = LoggerFactory.getLogger(ServerMappingsRepository.class);
    private static final String syncIntervalFixedDelayString = "${gateway.mappings.syncInterval:43200000}";
    @Value(value="${gateway.mappings.syncInterval:43200000}")
    private String syncIntervalDelayString;
    @Autowired
    @Qualifier(value="pmAwareInventoryRepository")
    private InventoryRepository inventoryRepository;
    @Autowired
    @Qualifier(value="mappedNodesRepository")
    private MappedNodesRepository mappedNodesRepository;
    @Autowired
    private DeviceTypeRepository deviceTypeRepository;
    @Autowired
    private DeviceTypeMatchingService deviceTypeMatchingService;
    @Autowired
    private GatewayManager gatewayManager;
    @Autowired
    private ConnectionManager connectionManager;
    @Autowired
    private InventoryUpdateProcessingModeConfiguration processingModeConfiguration;
    private final Map<String, Object> locks = new ConcurrentHashMap();

    public synchronized void scheduleUpdateServerMappings() throws ServerNotConnectedException, OpcuaClientException {
        log.info("Fetching gateway mappings with interval {}", (Object)this.syncIntervalDelayString);
        DateTime lastUpdatedDateTime = DateTime.now();
        Map deviceTypeMap = this.deviceTypeRepository.getAllDeviceTypes();
        DeviceTypeFetchedItems deviceTypeFetchedItems = new DeviceTypeFetchedItems(deviceTypeMap, true);
        Collection serverIdentifiers = this.gatewayManager.getGatewayDetails().getServerIdentifiers();
        if (Objects.nonNull(serverIdentifiers)) {
            for (ServerIdentifier serverIdentifier : serverIdentifiers) {
                this.updateServerMapping(serverIdentifier.getInventoryIdentifier().getValue(), deviceTypeFetchedItems, lastUpdatedDateTime);
            }
        }
    }

    public void onAddressSpaceUpdated(AddressSpaceUpdatedEvent event) throws ServerNotConnectedException, OpcuaClientException {
        log.info("Address space updated, updating device type mappings for server: {}", (Object)event.getServerId());
        DateTime lastUpdatedDateTime = DateTime.now();
        Map deviceTypeMap = this.deviceTypeRepository.getAllDeviceTypes();
        DeviceTypeFetchedItems deviceTypeFetchedItems = new DeviceTypeFetchedItems(deviceTypeMap, true);
        this.updateServerMapping(event.getServerId().getInventoryIdentifier().getValue(), deviceTypeFetchedItems, lastUpdatedDateTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServerMapping(String serverId, DeviceTypeFetchedItems deviceTypeFetchedItems, DateTime updatedDateTime) throws ServerNotConnectedException, OpcuaClientException {
        Object object = this.acquireLockForServer(serverId);
        synchronized (object) {
            log.info("Start update mappings for server: {}", (Object)serverId);
            Collection matchingNodes = this.deviceTypeMatchingService.matches(serverId, new ArrayList(deviceTypeFetchedItems.getDeviceTypes().values()));
            Optional connection = this.connectionManager.getConnection(new ServerIdentifier(GId.asGId((String)serverId)));
            if (!connection.isPresent()) {
                log.info("Server is not connected, skip updating server mapping.");
                return;
            }
            DeviceTypeMappedNodeCollection deviceTypeMappedNodeCollection = new DeviceTypeMappedNodeCollection();
            deviceTypeMappedNodeCollection.setLastUpdated(updatedDateTime);
            matchingNodes.forEach(arg_0 -> ((DeviceTypeMappedNodeCollection)deviceTypeMappedNodeCollection).addMappedNode(arg_0));
            if (!deviceTypeFetchedItems.isAllDeviceTypes()) {
                Collection otherApplicableDeviceTypeMappedNodes = this.getOtherApplicableDeviceTypeMappedNodes(serverId, matchingNodes, deviceTypeFetchedItems);
                otherApplicableDeviceTypeMappedNodes.forEach(arg_0 -> ((DeviceTypeMappedNodeCollection)deviceTypeMappedNodeCollection).addMappedNode(arg_0));
            }
            Nodes.useNsUriForMappedNodes((DeviceTypeMappedNodeCollection)deviceTypeMappedNodeCollection, (NamespaceTable)((OpcuaClient)connection.get()).getNamespaceTable());
            this.mappedNodesRepository.update(serverId, deviceTypeMappedNodeCollection);
        }
    }

    private Collection<DeviceTypeMappedNode> getOtherApplicableDeviceTypeMappedNodes(String serverId, Collection<DeviceTypeMappedNode> matchingNodes, DeviceTypeFetchedItems deviceTypeFetchedItems) {
        DeviceTypeMappedNodeCollection prevDTMappedNodeCollection = this.getServerMappedNodes(serverId);
        ArrayList<DeviceTypeMappedNode> otherApplicableDTMappedNodes = new ArrayList<DeviceTypeMappedNode>();
        HashSet matchedDeviceTypeIds = new HashSet();
        matchingNodes.forEach(deviceTypeMappedNode -> matchedDeviceTypeIds.add(deviceTypeMappedNode.getDeviceTypeId()));
        HashSet nonApplicableDeviceTypeIds = new HashSet();
        deviceTypeFetchedItems.getDeviceTypes().forEach((deviceTypeId, deviceType) -> {
            if (!matchedDeviceTypeIds.contains(deviceTypeId)) {
                nonApplicableDeviceTypeIds.add(deviceTypeId);
            }
        });
        prevDTMappedNodeCollection.getMappings().forEach(deviceTypeMappedNode -> {
            if (!matchedDeviceTypeIds.contains(deviceTypeMappedNode.getDeviceTypeId()) && !nonApplicableDeviceTypeIds.contains(deviceTypeMappedNode.getDeviceTypeId())) {
                otherApplicableDTMappedNodes.add((DeviceTypeMappedNode)deviceTypeMappedNode);
            }
        });
        return otherApplicableDTMappedNodes;
    }

    public DeviceTypeMappedNodeCollection getServerMappedNodes(String serverId) {
        DeviceTypeMappedNodeCollection collectionFromInventory = (DeviceTypeMappedNodeCollection)this.inventoryRepository.get(GId.asGId((String)serverId)).get(DeviceTypeMappedNodeCollection.class);
        if (Objects.nonNull(collectionFromInventory)) {
            ManagedObjectRepresentation mo = new ManagedObjectRepresentation();
            mo.setId(GId.asGId((String)serverId));
            mo.set(null, DeviceTypeMappedNodeCollection.class);
            this.inventoryRepository.update(mo);
            if (Objects.isNull(this.mappedNodesRepository.get(serverId))) {
                this.mappedNodesRepository.create(serverId, collectionFromInventory);
            }
            log.info("Device type mapped node for server {} are removed from inventory", (Object)serverId);
        }
        return this.mappedNodesRepository.get(serverId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object acquireLockForServer(String serverId) {
        Map map = this.locks;
        synchronized (map) {
            if (this.locks.containsKey(serverId)) {
                return this.locks.get(serverId);
            }
            Object lock = new Object();
            this.locks.put(serverId, lock);
            return lock;
        }
    }
}

