/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.datavalue.handler;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.datavalue.repository.DataValueStatusAlarmRepository;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.BaseDataValueEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.ValueAbnormalStatusCodeEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.ValueReadSuccessfulEvent;
import com.cumulocity.opcua.client.gateway.subscription.model.DataChangedEvent;
import com.cumulocity.rest.representation.alarm.AlarmRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
public class DataValueStatusHandler {
    private static final Logger log = LoggerFactory.getLogger(DataValueStatusHandler.class);
    private final DataValueStatusAlarmRepository valAlarmRepository;
    private final GatewayManager gatewayManager;

    @Order(value=2)
    public void loadPersistedToRepository() {
        Collection servers = this.gatewayManager.getAllGatewayServers();
        log.debug("Bootstrap ready event received. Loading data value abnormal alarms for server {}", (Object)servers);
        for (ManagedObjectRepresentation server : servers) {
            log.info("Loading active data value abnormal alarms for server {}", (Object)server.getId());
            this.valAlarmRepository.loadActiveAlarms(server.getId());
        }
    }

    public void onValueAbnormalStatusCodeEvent(ValueAbnormalStatusCodeEvent event) {
        this.setupAlarmToCreate((BaseDataValueEvent)event);
    }

    public void onValueReadSuccessfulEvent(ValueReadSuccessfulEvent event) {
        this.setupAlarmToClear((BaseDataValueEvent)event);
    }

    public void onValueDataChangedEvent(DataChangedEvent event) {
        this.setupAlarmToClear((BaseDataValueEvent)event);
    }

    public void handleAlarmsCreationAndClearing() {
        Map alarmsToCreate = this.valAlarmRepository.getAlarmsToCreate();
        Map alarmsToClear = this.valAlarmRepository.getAlarmsToClear();
        HashSet<String> serversWithChangedActiveAlarms = new HashSet<String>();
        for (Map.Entry alarmsToClearForServer : alarmsToClear.entrySet()) {
            for (Map.Entry alarmToClearForServer : ((Map)alarmsToClearForServer.getValue()).entrySet()) {
                if (!this.executeAlarmClearing((String)alarmsToClearForServer.getKey(), alarmToClearForServer)) continue;
                serversWithChangedActiveAlarms.add((String)alarmsToClearForServer.getKey());
            }
        }
        for (Map.Entry alarmsToCreateForServer : alarmsToCreate.entrySet()) {
            for (Map.Entry alarmToCreateForServer : ((Map)alarmsToCreateForServer.getValue()).entrySet()) {
                if (!this.executeAlarmCreation((String)alarmsToCreateForServer.getKey(), alarmToCreateForServer)) continue;
                serversWithChangedActiveAlarms.add((String)alarmsToCreateForServer.getKey());
            }
        }
        for (String serverId : serversWithChangedActiveAlarms) {
            this.valAlarmRepository.persistActiveAlarmsForServer(serverId);
        }
    }

    private boolean executeAlarmClearing(String serverId, Map.Entry<String, String> alarmToClearForServer) {
        String nodeId = alarmToClearForServer.getKey();
        log.info("Data value of node {} of server with id {} is back to normal. Clearing data value abnormal alarm", (Object)nodeId, (Object)serverId);
        if (this.valAlarmRepository.clearAlarmForServer(serverId, nodeId, GId.asGId((String)alarmToClearForServer.getValue())).isPresent()) {
            this.valAlarmRepository.removeFromActiveAlarms(serverId, nodeId);
            this.valAlarmRepository.removeFromAlarmsToClear(serverId, nodeId);
            return true;
        }
        return false;
    }

    private boolean executeAlarmCreation(String serverId, Map.Entry<String, BaseDataValueEvent> alarmToCreateForServer) {
        log.info("Data Value of node {} of server with id {} is abnormal. Creating data value abnormal alarm", (Object)alarmToCreateForServer.getKey(), (Object)serverId);
        Optional abnormalValAlarm = this.valAlarmRepository.createAlarmForServer(serverId, alarmToCreateForServer.getValue());
        if (abnormalValAlarm.isPresent()) {
            this.setupActiveAlarm(alarmToCreateForServer.getValue(), (AlarmRepresentation)abnormalValAlarm.get());
            return true;
        }
        return false;
    }

    private void setupAlarmToClear(BaseDataValueEvent event) {
        String serverId = event.getServerId();
        String nodeId = event.getNodeId();
        this.valAlarmRepository.removeFromAlarmsToCreate(serverId, nodeId);
        Optional alarm = this.valAlarmRepository.getActiveAlarmsForServerNode(serverId, nodeId);
        if (alarm.isPresent()) {
            this.valAlarmRepository.setAlarmToClearForServer(serverId, nodeId, (GId)alarm.get());
        }
    }

    private void setupAlarmToCreate(BaseDataValueEvent event) {
        String nodeId;
        String serverId = event.getServerId();
        if (!this.valAlarmRepository.containedInAlarmToCreateForServerNode(serverId, nodeId = event.getNodeId()) && !this.valAlarmRepository.containedInActiveAlarmForServerNode(serverId, nodeId)) {
            this.valAlarmRepository.setAlarmToCreateForServer(serverId, nodeId, event);
        }
        this.valAlarmRepository.removeFromAlarmsToClear(serverId, nodeId);
    }

    private void setupActiveAlarm(BaseDataValueEvent event, AlarmRepresentation alarmRepresentation) {
        String serverId = event.getServerId();
        String nodeId = event.getNodeId();
        this.valAlarmRepository.removeFromAlarmsToCreate(serverId, nodeId);
        this.valAlarmRepository.setActiveAlarmForServer(serverId, nodeId, alarmRepresentation.getId());
    }

    @Autowired
    public DataValueStatusHandler(DataValueStatusAlarmRepository valAlarmRepository, GatewayManager gatewayManager) {
        this.valAlarmRepository = valAlarmRepository;
        this.gatewayManager = gatewayManager;
    }
}

