/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PlatformThinEdgeConfiguration {
    private static final Logger log = LoggerFactory.getLogger(PlatformThinEdgeConfiguration.class);
    @Value(value="${gateway.thinEdge.enabled:false}")
    private boolean enabled;
    @Value(value="${gateway.thinEdge.mqttServerURL}")
    private String mqttServerUrl;
    @Value(value="${gateway.thinEdge.deviceId}")
    private String thinEdgeDeviceId;
    @Value(value="${gateway.thinEdge.mqttSteadyConnection}")
    private Boolean mqttSteadyConnection;
    @Value(value="${gateway.thinEdge.mqttAutomaticReconnect:true}")
    private boolean mqttAutomaticReconnect;
    @Value(value="${gateway.thinEdge.mqttCleanSession:true}")
    private boolean mqttCleanSession;
    @Value(value="${gateway.thinEdge.mqttConnectionTimeout:30}")
    private int mqttConnectionTimeout;
    @Value(value="${gateway.thinEdge.mqttKeepAliveInterval:60}")
    private int mqttKeepAliveInterval;
    @Value(value="${gateway.thinEdge.mqttMaxInFlight:1000}")
    private int mqttMaxInFlight;
    @Value(value="${gateway.thinEdge.useForDataForwarding:false}")
    private boolean useForDataForwarding;

    public void afterPropertiesSet() throws Exception {
        log.info("Gateway thin-edge configuration: {}", (Object)this);
    }

    public String toString() {
        return "PlatformThinEdgeConfiguration(enabled=" + this.isEnabled() + ", mqttServerUrl=" + this.getMqttServerUrl() + ", thinEdgeDeviceId=" + this.getThinEdgeDeviceId() + ", mqttSteadyConnection=" + this.getMqttSteadyConnection() + ", mqttAutomaticReconnect=" + this.isMqttAutomaticReconnect() + ", mqttCleanSession=" + this.isMqttCleanSession() + ", mqttConnectionTimeout=" + this.getMqttConnectionTimeout() + ", mqttKeepAliveInterval=" + this.getMqttKeepAliveInterval() + ", mqttMaxInFlight=" + this.getMqttMaxInFlight() + ", useForDataForwarding=" + this.isUseForDataForwarding() + ")";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getMqttServerUrl() {
        return this.mqttServerUrl;
    }

    public String getThinEdgeDeviceId() {
        return this.thinEdgeDeviceId;
    }

    public Boolean getMqttSteadyConnection() {
        return this.mqttSteadyConnection;
    }

    public boolean isMqttAutomaticReconnect() {
        return this.mqttAutomaticReconnect;
    }

    public boolean isMqttCleanSession() {
        return this.mqttCleanSession;
    }

    public int getMqttConnectionTimeout() {
        return this.mqttConnectionTimeout;
    }

    public int getMqttKeepAliveInterval() {
        return this.mqttKeepAliveInterval;
    }

    public int getMqttMaxInFlight() {
        return this.mqttMaxInFlight;
    }

    public boolean isUseForDataForwarding() {
        return this.useForDataForwarding;
    }
}

