/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.configuration;

import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HttpConnectionConfiguration {
    private static final Logger log = LoggerFactory.getLogger(HttpConnectionConfiguration.class);
    @Value(value="${gateway.mappingExecution.http.maxPerRoute:50}")
    private int maxPerRoute;
    @Value(value="${gateway.mappingExecution.http.maxTotal:100}")
    private int maxTotal;
    @Value(value="${gateway.mappingExecution.http.inactivityLeaseTimeout:50000}")
    private int inactivityLeaseTimeout;

    public void afterPropertiesSet() {
        log.info("Gateway http connection configuration: {}", (Object)this);
    }

    @Bean
    public HttpClient httpClient() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setDefaultMaxPerRoute(this.maxPerRoute);
        cm.setMaxTotal(this.maxTotal);
        cm.setValidateAfterInactivity(this.inactivityLeaseTimeout);
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    public String toString() {
        return "HttpConnectionConfiguration(maxPerRoute=" + this.maxPerRoute + ", maxTotal=" + this.maxTotal + ", inactivityLeaseTimeout=" + this.inactivityLeaseTimeout + ")";
    }
}

