/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.configuration;

import com.cumulocity.opcua.client.gateway.configuration.GatewayGeneralConfiguration;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class GatewayGeneralConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GatewayGeneralConfiguration.class);
    @Value(value="${gateway.identifier:${user.name}}")
    private String gatewayIdentifier;
    @Value(value="${gateway.name:${user.name}}")
    private String gatewayName;
    @Value(value="${C8Y.baseUrl}")
    private String baseUrl;
    @Value(value="${C8Y.forceInitialHost:false}")
    private boolean forceInitialHost;
    @Value(value="${gateway.bootstrap.force:false}")
    private boolean forcedBootstrap;
    @Value(value="${gateway.operation.autoScanAddressSpace:true}")
    private boolean autoScanAddressSpace;
    @Value(value="${gateway.operation.queueSize:100}")
    private int operationQueueSize;
    @Value(value="${gateway.childrenAddedOrRemoveCheck.interval:60000}")
    private long detectServersAddedOrRemoveInterval;
    @Value(value="${gateway.shortPolling.enabled:true}")
    private boolean shortPollingEnabled;
    @Value(value="${gateway.shortPolling.fixedDelay:30000}")
    private long shortPollingFixedDelayMils;
    @Value(value="${gateway.connectivity.triggerManualReconnectOnConnectionDrop:true}")
    private Boolean triggerManualReconnectOnConnectionDrop;
    @Value(value="${gateway.connectivity.validateDiscoveredEndpoints:}")
    private Boolean validateDiscoveredEndpoints;
    @Value(value="${gateway.operation.validateDeviceOperationNodes:true}")
    private boolean validateDeviceOperationNodes;
    @Autowired
    private DeviceBootstrapConfiguration bootstrapConfig;
    @Autowired
    private Environment environment;

    @PostConstruct
    public void printGatewayInformation() {
        String gatewayVersion = this.environment.getProperty("gateway.version");
        log.info("GATEWAY VERSION: {}", (Object)gatewayVersion);
        log.info("GATEWAY IDENTIFIER: {}", (Object)this.gatewayIdentifier);
        log.info("Gateway general configuration: {}", (Object)this);
    }

    public String toString() {
        return "GatewayGeneralConfiguration(gatewayIdentifier=" + this.getGatewayIdentifier() + ", gatewayName=" + this.getGatewayName() + ", baseUrl=" + this.getBaseUrl() + ", forceInitialHost=" + this.isForceInitialHost() + ", forcedBootstrap=" + this.isForcedBootstrap() + ", autoScanAddressSpace=" + this.isAutoScanAddressSpace() + ", operationQueueSize=" + this.getOperationQueueSize() + ", detectServersAddedOrRemoveInterval=" + this.getDetectServersAddedOrRemoveInterval() + ", shortPollingEnabled=" + this.isShortPollingEnabled() + ", shortPollingFixedDelayMils=" + this.getShortPollingFixedDelayMils() + ", triggerManualReconnectOnConnectionDrop=" + this.getTriggerManualReconnectOnConnectionDrop() + ", validateDiscoveredEndpoints=" + this.getValidateDiscoveredEndpoints() + ", validateDeviceOperationNodes=" + this.isValidateDeviceOperationNodes() + ", bootstrapConfig=" + this.getBootstrapConfig() + ", environment=" + this.getEnvironment() + ")";
    }

    public String getGatewayIdentifier() {
        return this.gatewayIdentifier;
    }

    public String getGatewayName() {
        return this.gatewayName;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isForceInitialHost() {
        return this.forceInitialHost;
    }

    public boolean isForcedBootstrap() {
        return this.forcedBootstrap;
    }

    public boolean isAutoScanAddressSpace() {
        return this.autoScanAddressSpace;
    }

    public int getOperationQueueSize() {
        return this.operationQueueSize;
    }

    public long getDetectServersAddedOrRemoveInterval() {
        return this.detectServersAddedOrRemoveInterval;
    }

    public boolean isShortPollingEnabled() {
        return this.shortPollingEnabled;
    }

    public long getShortPollingFixedDelayMils() {
        return this.shortPollingFixedDelayMils;
    }

    public Boolean getTriggerManualReconnectOnConnectionDrop() {
        return this.triggerManualReconnectOnConnectionDrop;
    }

    public Boolean getValidateDiscoveredEndpoints() {
        return this.validateDiscoveredEndpoints;
    }

    public boolean isValidateDeviceOperationNodes() {
        return this.validateDeviceOperationNodes;
    }

    public DeviceBootstrapConfiguration getBootstrapConfig() {
        return this.bootstrapConfig;
    }

    public Environment getEnvironment() {
        return this.environment;
    }
}

