/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.bootstrap.service;

import com.cumulocity.model.ID;
import com.cumulocity.model.option.OptionPK;
import com.cumulocity.opcua.client.gateway.bootstrap.model.BootstrapReadyEvent;
import com.cumulocity.opcua.client.gateway.configuration.GatewayGeneralConfiguration;
import com.cumulocity.opcua.client.gateway.jmx.ServerMonitoringMBean;
import com.cumulocity.opcua.client.gateway.platform.factory.IdentityFactory;
import com.cumulocity.opcua.client.gateway.platform.model.PlatformConnectionReadyEvent;
import com.cumulocity.opcua.client.gateway.platform.repository.IdentityRepository;
import com.cumulocity.opcua.common.repository.InventoryRepository;
import com.cumulocity.rest.representation.identity.ExternalIDRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.SDKException;
import com.cumulocity.sdk.client.option.SystemOptionApi;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public abstract class BootstrapService {
    private static final Logger log = LoggerFactory.getLogger(BootstrapService.class);
    protected final ServerMonitoringMBean mbean;
    protected final GatewayGeneralConfiguration configuration;
    protected final ApplicationEventPublisher eventPublisher;
    protected final IdentityRepository identityRepository;
    protected final InventoryRepository inventoryRepository;
    protected final SystemOptionApi systemOptionApi;

    public void afterPropertiesSet() {
        log.info("Bootstrapping with " + this.getClass().getSimpleName() + " is starting ...");
        this.mbean.setGatewayStarted(Boolean.valueOf(true));
    }

    public void createDeviceIfNotExist(PlatformConnectionReadyEvent platformConnectionReadyEvent) throws InterruptedException {
        ManagedObjectRepresentation deviceMO;
        Optional existingIdentity;
        log.info("Platform connection is ready, creating device if it's not there");
        this.printPlatformVersion();
        ID deviceId = IdentityFactory.createID((String)this.configuration.getGatewayIdentifier());
        try {
            existingIdentity = this.identityRepository.get(IdentityFactory.createID((String)this.configuration.getGatewayIdentifier()));
        }
        catch (Throwable e) {
            if (this.detectInvalidCredentials(e)) {
                this.onInvalidCredentials();
                System.exit(1);
            }
            log.error("Unable to get gateway identity, reason: {}, will try again in 5 seconds", (Object)e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug("Details: ", e);
            }
            Thread.sleep(5000L);
            this.createDeviceIfNotExist(platformConnectionReadyEvent);
            return;
        }
        if (!existingIdentity.isPresent()) {
            deviceMO = this.createDevice(deviceId);
        } else {
            deviceMO = this.inventoryRepository.get(((ExternalIDRepresentation)existingIdentity.get()).getManagedObject().getId());
            if (!platformConnectionReadyEvent.getUserName().equals(deviceMO.getOwner())) {
                log.error("Current gateway device managed object is owned by another user ({}) , please change it to [{}]. \n Shutting down platform...", (Object)deviceMO.getOwner(), (Object)platformConnectionReadyEvent.getUserName());
                System.exit(1);
            }
        }
        this.eventPublisher.publishEvent((Object)new BootstrapReadyEvent(deviceMO));
    }

    private void printPlatformVersion() {
        try {
            log.info("Platform version: {}", (Object)this.systemOptionApi.getOption(new OptionPK("system", "version")).getValue());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean detectInvalidCredentials(Throwable e) {
        Throwable cause = e;
        while (!Objects.isNull(cause.getCause())) {
            SDKException sdkException;
            if (cause.getCause() instanceof SDKException && (sdkException = (SDKException)cause.getCause()).getHttpStatus() == 401) {
                return true;
            }
            cause = cause.getCause();
        }
        return false;
    }

    protected abstract void onInvalidCredentials();

    protected abstract ManagedObjectRepresentation createDevice(ID var1);

    public BootstrapService(ServerMonitoringMBean mbean, GatewayGeneralConfiguration configuration, ApplicationEventPublisher eventPublisher, IdentityRepository identityRepository, InventoryRepository inventoryRepository, SystemOptionApi systemOptionApi) {
        this.mbean = mbean;
        this.configuration = configuration;
        this.eventPublisher = eventPublisher;
        this.identityRepository = identityRepository;
        this.inventoryRepository = inventoryRepository;
        this.systemOptionApi = systemOptionApi;
    }
}

