/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway;

import c8y.ua.data.DeviceTypeMappedNodeCollection;
import com.cumulocity.opcua.client.gateway.bootstrap.model.DeviceCredentials;
import com.cumulocity.opcua.client.gateway.datastore.DataStore;
import com.cumulocity.opcua.client.gateway.datastore.GatewayLocalDatabase;
import com.cumulocity.opcua.client.gateway.datastore.model.EncryptionData;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import net.openhft.chronicle.map.ChronicleMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Component;

@Component
public class MigrateLocalDbToRocksDb
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MigrateLocalDbToRocksDb.class);
    @Autowired
    private GatewayLocalDatabase rocks;
    @Autowired
    @Qualifier(value="deviceTypeMappingStore")
    private ChronicleMap<String, DeviceTypeMappedNodeCollection> deviceTypeMappingStore;
    @Autowired
    @Qualifier(value="alarmStatusStore")
    private ChronicleMap<CharSequence, Long> alarmStatusStore;
    @Autowired
    @Qualifier(value="gatewayDataStore")
    private DataStore gatewayDataStore;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private TaskScheduler scheduler;

    public void afterPropertiesSet() throws Exception {
        log.info("Starting RocksDB migration in 5 seconds...");
        this.scheduler.schedule(() -> {
            this.migrateGatewayCredentials();
            this.migrateEncryptionKeys();
            this.migrateAddressSpaceServers();
            this.migrateAlarmCache();
            this.migrateDeviceTypeMappings();
            log.info("Migration completed.");
            SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
            System.exit(0);
        }, new Date(System.currentTimeMillis() + 5000L));
    }

    private void migrateDeviceTypeMappings() {
        log.info("Migrating device type mappings: {} mappings to migrate.", (Object)this.deviceTypeMappingStore.size());
        this.deviceTypeMappingStore.forEach((cs, collection) -> this.rocks.addDeviceTypeMapping(cs, collection));
    }

    private void migrateAlarmCache() {
        log.info("Migrating alarm cache: {} alarms to migrate.", (Object)this.alarmStatusStore.size());
        this.alarmStatusStore.forEach((cs, l) -> this.rocks.addAlarmCache(cs.toString(), l.toString()));
    }

    private void migrateGatewayCredentials() {
        log.info("Migrating gateway credentials...");
        Optional credentialsOptional = this.gatewayDataStore.get("deviceCredentials");
        if (credentialsOptional.isPresent()) {
            DeviceCredentials credentials = (DeviceCredentials)credentialsOptional.get();
            log.info("Adding gateway credentials {}/{} to RocksDB.", (Object)credentials.getTenant(), (Object)credentials.getUsername());
            this.rocks.setCredentials(credentials);
        } else {
            log.info("No gateway credentials to migrate.");
        }
    }

    private void migrateEncryptionKeys() {
        log.info("Migrating encryption keys...");
        Optional salt = this.gatewayDataStore.get("connectionSalt");
        Optional iv = this.gatewayDataStore.get("initializationVector");
        Optional secret = this.gatewayDataStore.get("secret");
        String saltStr = salt.orElse(null);
        String ivStr = iv.orElse(null);
        String secretStr = secret.orElse(null);
        log.info("Adding encryption keys to RocksDB.");
        this.rocks.setEncryptionData(new EncryptionData(saltStr, ivStr, secretStr));
    }

    private void migrateAddressSpaceServers() {
        log.info("Migrating address space servers...");
        Optional servers = this.gatewayDataStore.get("scannedAddressSpaceServers");
        if (servers.isPresent()) {
            String[] serverArray = (String[])servers.get();
            HashSet<String> serverSet = new HashSet<String>(Arrays.asList(serverArray));
            for (String server : serverSet) {
                log.info("Adding server {} to RocksDB scanned servers.", (Object)server);
                this.rocks.addScannedServer(server);
            }
        } else {
            log.info("No address space servers to migrate.");
        }
    }
}

