/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway;

import c8y.ua.ClientConfig;
import c8y.ua.IdentityConfig;
import com.cumulocity.model.event.CumulocitySeverities;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.IdentityTools;
import com.cumulocity.opcua.client.gateway.AddressSpaceCleaner;
import com.cumulocity.opcua.client.gateway.GatewayDetails;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.bootstrap.model.BootstrapReadyEvent;
import com.cumulocity.opcua.client.gateway.configuration.GatewayGeneralConfiguration;
import com.cumulocity.opcua.client.gateway.configuration.InventoryUpdateProcessingModeConfiguration;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.connection.model.ReestablishConnectionEvent;
import com.cumulocity.opcua.client.gateway.connection.model.ServerDisconnectedEvent;
import com.cumulocity.opcua.client.gateway.connection.model.ServerReconnectedEvent;
import com.cumulocity.opcua.client.gateway.cyclicreader.CyclicReadExecutor;
import com.cumulocity.opcua.client.gateway.datastore.DataStore;
import com.cumulocity.opcua.client.gateway.encryption.EncryptionService;
import com.cumulocity.opcua.client.gateway.mappings.DeviceTypeRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.AlarmRepository;
import com.cumulocity.opcua.common.repository.InventoryRepository;
import com.cumulocity.opcua.common.valuemap.ValueMapRepository;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Component;

@Component
public class GatewayManager {
    private static final Logger log = LoggerFactory.getLogger(GatewayManager.class);
    @Autowired
    private EncryptionService encryptionService;
    public static final String GATEWAY_CRASH_DB_KEY = "gateway_crash_check";
    private final GatewayGeneralConfiguration generalConfiguration;
    private final CyclicReadExecutor cyclicReadExecutor;
    private final ConnectionManager connectionManager;
    private final ApplicationEventPublisher eventPublisher;
    @Lazy
    @Qualifier(value="pmAwareInventoryRepository")
    private final InventoryRepository inventoryRepository;
    @Lazy
    private final AlarmRepository alarmRepository;
    @Lazy
    private final DataStore dataStore;
    private final TaskScheduler scheduler;
    private final AddressSpaceCleaner addressSpaceCleaner;
    private final ValueMapRepository valueMapRepository;
    private final InventoryUpdateProcessingModeConfiguration processingModeConfiguration;
    private DeviceTypeRepository deviceTypeRepository;
    private boolean gatewayCrashAlreadyChecked = false;
    private volatile GatewayDetails gatewayDetails;
    private final IdentityTools identityTools;
    private boolean opcuaConnectionDisabled = false;

    public void disableOPCUACommunication() {
        log.info("Disabling all OPC UA communication");
        this.cyclicReadExecutor.removeAllCyclicReads();
        this.connectionManager.closeAllConnections();
        this.gatewayDetails.clearServerIdentifiers();
        this.opcuaConnectionDisabled = true;
    }

    public void enableOPCUACommunication() {
        if (this.opcuaConnectionDisabled) {
            log.info("(Re-)Enabling all OPC UA Communication");
            this.reestablishServerConnections();
        }
    }

    public ManagedObjectRepresentation addChildDeviceToGateway(ClientConfig clientConfig, String name) {
        ManagedObjectRepresentation gatewayDevice = this.gatewayDetails.getGatewayDevice();
        ManagedObjectRepresentation childDevice = new ManagedObjectRepresentation();
        childDevice.setType("c8y_OpcuaServer");
        childDevice.setName(name);
        childDevice.set((Object)clientConfig, "c8y_ua_ClientConfig");
        return this.inventoryRepository.createChildDevice(childDevice, gatewayDevice.getId());
    }

    public void removeServerFromGateway(ServerDisconnectedEvent serverDisconnectedEvent) {
        log.info("Remove server " + serverDisconnectedEvent.getServerIdentifier());
        this.gatewayDetails.removeServer(serverDisconnectedEvent.getServerIdentifier());
    }

    @Order(value=1)
    public void establishServerConnections(BootstrapReadyEvent bootstrapReadyEvent) {
        log.info("Bootstrapping is done, gateway device is available: {}", (Object)bootstrapReadyEvent.getGatewayDevice().getId());
        this.gatewayDetails.setGatewayDevice(bootstrapReadyEvent.getGatewayDevice());
        this.connectToAllServers(false);
        log.info("Scheduling OPC UA servers added/removed/updated with fixed delay: {}", (Object)this.generalConfiguration.getDetectServersAddedOrRemoveInterval());
        this.scheduler.scheduleWithFixedDelay(() -> this.detectServersAddedRemovedOrUpdated(), this.generalConfiguration.getDetectServersAddedOrRemoveInterval());
        this.gatewayDetails.setFullyInitialized(true);
        this.checkIfGatewayCrashed();
        log.info("Gateway is fully initialized! Details: {}", (Object)this.gatewayDetails);
    }

    public void connectToAllServers(boolean generateReconnectEvent) {
        Collection allServers = this.getAllGatewayServers();
        log.info("Found {} child device(s), trying to connect to them if OPCUA config is available", (Object)allServers.size());
        for (ManagedObjectRepresentation serverMO : allServers) {
            this.connectToServer(serverMO, generateReconnectEvent);
        }
    }

    public void reestablishServerConnections() {
        this.opcuaConnectionDisabled = false;
        this.connectToAllServers(true);
    }

    public Collection<ManagedObjectRepresentation> getAllGatewayServers() {
        return Optional.of(this.inventoryRepository.getChildDevices(this.gatewayDetails.getGatewayDevice().getId())).orElseGet(ArrayList::new);
    }

    public void checkIfGatewayCrashed() {
        if (this.gatewayCrashAlreadyChecked) {
            log.debug("Checked for gateway crash before, skipping now.");
            return;
        }
        log.info("Checking if gateway crashed on last run...");
        if (this.dataStore.get(GATEWAY_CRASH_DB_KEY).isPresent()) {
            log.warn("Gateway crash key exists in data store - creating alarm!");
            this.alarmRepository.create(this.gatewayDetails.getGatewayDevice().getId(), "c8y_ua_GatewayCrash", CumulocitySeverities.MAJOR.name(), "Gateway crashed on last run! Please check the log files and memory dumps to see what caused this.");
        } else {
            log.info("Gateway was closed gracefully. Creating entry in data store for next run.");
            this.dataStore.store(GATEWAY_CRASH_DB_KEY, (Serializable)((Object)"1"));
        }
        this.gatewayCrashAlreadyChecked = true;
    }

    public void onReestablishConnection(ReestablishConnectionEvent serverId) {
        Optional<ManagedObjectRepresentation> serverMO = this.getAllGatewayServers().stream().filter(c -> c.getId().equals((Object)serverId.getServerIdentifier().getInventoryIdentifier())).findAny();
        if (!this.connectionManager.isServerConnected(serverId.getServerIdentifier()) && serverMO.isPresent()) {
            log.debug("Reconnect to the server: {}, MO: {}", (Object)serverId.getServerIdentifier(), (Object)serverMO.get());
            this.connectToServer(serverMO.get(), true);
        }
    }

    private void connectToServer(ManagedObjectRepresentation serverMO, boolean generateReconnectEvent) {
        ClientConfig clientConfig = (ClientConfig)serverMO.get("c8y_ua_ClientConfig");
        if (Objects.isNull(clientConfig)) {
            log.warn("Connection config is not set for server: {}", (Object)serverMO.getId().getValue());
            return;
        }
        if (this.opcuaConnectionDisabled) {
            log.warn("OPC UA communication is disabled. Skipping connecting to {}", (Object)clientConfig.getServerUrl());
            return;
        }
        if (clientConfig.checkParameter().isLeft()) {
            log.warn("Connection config is not valid for server: {}, {}", (Object)clientConfig, (Object)serverMO.getId().getValue());
            return;
        }
        if ("disabled".equalsIgnoreCase(clientConfig.getTargetConnectionState())) {
            log.info("Target connections state of server: [{}] is disabled, will not connect", (Object)serverMO.getId().getValue());
            return;
        }
        ServerIdentifier serverIdentifier = new ServerIdentifier(serverMO.getName(), serverMO.getId(), null);
        try {
            this.gatewayDetails.addServer(serverIdentifier);
            log.info("Server {} added to gateway", (Object)serverIdentifier);
            this.connectionManager.getOrConnect(serverIdentifier, clientConfig);
            log.info("Server {} connected", (Object)serverIdentifier);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to connect to server: {}", (Object)serverIdentifier, (Object)e);
            } else {
                log.error("Unable to connect to server: {}, reason: {}", (Object)serverIdentifier, (Object)e.getMessage());
            }
            this.gatewayDetails.removeServer(serverIdentifier);
        }
        if (generateReconnectEvent) {
            this.eventPublisher.publishEvent((Object)new ServerReconnectedEvent(serverIdentifier, clientConfig));
        }
    }

    void detectServersAddedRemovedOrUpdated() {
        if (Objects.isNull(this.inventoryRepository) || Objects.isNull(this.gatewayDetails.getGatewayDevice())) {
            log.info("Platform connection is not ready, try again next round");
            return;
        }
        Collection freshServers = this.inventoryRepository.getChildDevices(this.gatewayDetails.getGatewayDevice().getId());
        Collection localServers = this.connectionManager.getAllServerIdentifiers();
        Collection toConnects = freshServers.stream().filter(serverMO -> localServers.stream().noneMatch(serverIdentifier -> serverIdentifier.getInventoryIdentifier().equals((Object)serverMO.getId()))).filter(arg_0 -> this.isTargetConnectionEnabled(arg_0)).collect(Collectors.toSet());
        Supplier<Stream> removedServers = () -> localServers.stream().filter(localServer -> freshServers.stream().noneMatch(serverMO -> serverMO.getId().equals((Object)localServer.getInventoryIdentifier())));
        Collection removeLocalStored = removedServers.get().collect(Collectors.toSet());
        Stream<ServerIdentifier> disabledServers = localServers.stream().filter(localServer -> freshServers.stream().filter(serverMO -> serverMO.getId().equals((Object)localServer.getInventoryIdentifier())).anyMatch(arg_0 -> this.isTargetConnectionDisabled(arg_0)));
        Collection toDisconnects = Stream.concat(removedServers.get(), disabledServers).collect(Collectors.toSet());
        Collection toUpdates = freshServers.stream().filter(arg_0 -> this.isTargetConnectionUpdated(arg_0)).collect(Collectors.toSet());
        for (ServerIdentifier toDisconnect : toDisconnects) {
            this.connectionManager.disconnect(toDisconnect);
            this.gatewayDetails.removeServer(toDisconnect);
        }
        for (ServerIdentifier removedServer : removeLocalStored) {
            this.connectionManager.removeServerFromLocal(removedServer);
        }
        for (ManagedObjectRepresentation toConnect : toConnects) {
            this.connectToServer(toConnect, false);
        }
        for (ManagedObjectRepresentation toUpdate : toUpdates) {
            ServerIdentifier serverIdentifier = new ServerIdentifier(toUpdate.getName(), toUpdate.getId(), null);
            if (this.connectionManager.isServerConnected(serverIdentifier)) {
                this.connectionManager.disconnect(serverIdentifier);
                log.info("Server {} disconnected for update", (Object)toUpdate.getName());
            }
            ClientConfig config = (ClientConfig)toUpdate.get("c8y_ua_ClientConfig");
            config.setTargetUpdateState(Boolean.valueOf(false));
            ManagedObjectRepresentation updateable = new ManagedObjectRepresentation();
            updateable.set((Object)config, "c8y_ua_ClientConfig");
            updateable.setId(toUpdate.getId());
            this.inventoryRepository.update(updateable, this.processingModeConfiguration.getServerUpdateProcessingMode());
            this.connectToServer(toUpdate, false);
        }
        removedServers.get().forEach(si -> {
            log.info("Deleting Value Map for server {}", si);
            this.valueMapRepository.deleteServerValueMapForServer(si.getInventoryIdentifier().getValue());
        });
        this.addressSpaceCleaner.tryClean(removedServers.get(), this.gatewayDetails.getGatewayDevice().getOwner());
    }

    public void afterPropertiesSet() {
        this.gatewayDetails = GatewayDetails.builder().generalConfiguration(this.generalConfiguration).build();
    }

    public IdentityConfig getApplicationIdentity() throws IOException, GeneralSecurityException {
        log.info("Reading application identity config from gateway MO");
        GId gatewayId = this.getGatewayDetails().getGatewayDevice().getId();
        ManagedObjectRepresentation gatewayMo = this.inventoryRepository.get(gatewayId);
        IdentityConfig identityConfig = (IdentityConfig)gatewayMo.get(IdentityConfig.class);
        if (identityConfig != null) {
            if (Optional.ofNullable(identityConfig.getPkIsAESGCMEncrypted()).orElse(false).booleanValue()) {
                log.info("Encrypted identity config found");
                return identityConfig;
            }
            identityConfig.setPk((String)this.identityTools.encryptPrivateKey(identityConfig.getPrivateKey()).orElseThrow(GeneralSecurityException::new));
            identityConfig.setPkIsAESGCMEncrypted(Boolean.valueOf(true));
            log.info("Unencrypted identity config found, updated private key");
            return this.generateApplicationIdentity(gatewayId, identityConfig);
        }
        return this.generateApplicationIdentity(gatewayId, this.identityTools.generateApplicationIdentityConfig());
    }

    private IdentityConfig generateApplicationIdentity(GId gatewayId, IdentityConfig identityConfig) throws IOException, GeneralSecurityException {
        log.info("Update or generating new identity config");
        ManagedObjectRepresentation update = new ManagedObjectRepresentation();
        update.setId(gatewayId);
        update.set((Object)identityConfig);
        this.inventoryRepository.update(update, this.processingModeConfiguration.getGatewayUpdateProcessingMode());
        return identityConfig;
    }

    private Optional<ClientConfig> getClientConfig(ManagedObjectRepresentation serverMO) {
        ClientConfig clientConfig = (ClientConfig)serverMO.get("c8y_ua_ClientConfig");
        return Optional.ofNullable(clientConfig);
    }

    private boolean isTargetConnectionDisabled(ManagedObjectRepresentation serverMO) {
        Optional clientConfig = this.getClientConfig(serverMO);
        return !clientConfig.isPresent() || "disabled".equalsIgnoreCase(((ClientConfig)clientConfig.get()).getTargetConnectionState());
    }

    private boolean isTargetConnectionEnabled(ManagedObjectRepresentation serverMO) {
        return !this.isTargetConnectionDisabled(serverMO) && !this.isTargetConnectionUpdated(serverMO);
    }

    private boolean isTargetConnectionUpdated(ManagedObjectRepresentation serverMO) {
        Optional clientConfig = this.getClientConfig(serverMO);
        return clientConfig.isPresent() && ((ClientConfig)clientConfig.get()).getTargetUpdateState() != false;
    }

    @Autowired
    public GatewayManager(GatewayGeneralConfiguration generalConfiguration, CyclicReadExecutor cyclicReadExecutor, ConnectionManager connectionManager, ApplicationEventPublisher eventPublisher, InventoryRepository inventoryRepository, AlarmRepository alarmRepository, DataStore dataStore, TaskScheduler scheduler, AddressSpaceCleaner addressSpaceCleaner, ValueMapRepository valueMapRepository, InventoryUpdateProcessingModeConfiguration processingModeConfiguration, IdentityTools identityTools) {
        this.generalConfiguration = generalConfiguration;
        this.cyclicReadExecutor = cyclicReadExecutor;
        this.connectionManager = connectionManager;
        this.eventPublisher = eventPublisher;
        this.inventoryRepository = inventoryRepository;
        this.alarmRepository = alarmRepository;
        this.dataStore = dataStore;
        this.scheduler = scheduler;
        this.addressSpaceCleaner = addressSpaceCleaner;
        this.valueMapRepository = valueMapRepository;
        this.processingModeConfiguration = processingModeConfiguration;
        this.identityTools = identityTools;
    }

    public GatewayDetails getGatewayDetails() {
        return this.gatewayDetails;
    }

    public void setGatewayDetails(GatewayDetails gatewayDetails) {
        this.gatewayDetails = gatewayDetails;
    }

    public boolean isOpcuaConnectionDisabled() {
        return this.opcuaConnectionDisabled;
    }
}

