/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway;

import com.cumulocity.opcua.client.gateway.GatewayDetails;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.configuration.GatewayGeneralConfiguration;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public class GatewayDetails
implements Serializable {
    private final GatewayGeneralConfiguration generalConfiguration;
    private ManagedObjectRepresentation gatewayDevice;
    private Collection<ServerIdentifier> serverIdentifiers;
    private boolean fullyInitialized;

    void addServer(ServerIdentifier serverIdentifier) {
        if (Objects.isNull(this.serverIdentifiers)) {
            this.serverIdentifiers = new CopyOnWriteArrayList();
        }
        this.serverIdentifiers.add(serverIdentifier);
    }

    boolean removeServer(ServerIdentifier serverIdentifier) {
        if (Objects.isNull(this.serverIdentifiers)) {
            return false;
        }
        return this.serverIdentifiers.remove(serverIdentifier);
    }

    public void clearServerIdentifiers() {
        this.serverIdentifiers.clear();
    }

    GatewayDetails(GatewayGeneralConfiguration generalConfiguration, ManagedObjectRepresentation gatewayDevice, Collection<ServerIdentifier> serverIdentifiers, boolean fullyInitialized) {
        this.generalConfiguration = generalConfiguration;
        this.gatewayDevice = gatewayDevice;
        this.serverIdentifiers = serverIdentifiers;
        this.fullyInitialized = fullyInitialized;
    }

    public static GatewayDetailsBuilder builder() {
        return new GatewayDetailsBuilder();
    }

    public GatewayGeneralConfiguration getGeneralConfiguration() {
        return this.generalConfiguration;
    }

    public ManagedObjectRepresentation getGatewayDevice() {
        return this.gatewayDevice;
    }

    public Collection<ServerIdentifier> getServerIdentifiers() {
        return this.serverIdentifiers;
    }

    public boolean isFullyInitialized() {
        return this.fullyInitialized;
    }

    public void setGatewayDevice(ManagedObjectRepresentation gatewayDevice) {
        this.gatewayDevice = gatewayDevice;
    }

    public void setServerIdentifiers(Collection<ServerIdentifier> serverIdentifiers) {
        this.serverIdentifiers = serverIdentifiers;
    }

    public void setFullyInitialized(boolean fullyInitialized) {
        this.fullyInitialized = fullyInitialized;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GatewayDetails)) {
            return false;
        }
        GatewayDetails other = (GatewayDetails)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isFullyInitialized() != other.isFullyInitialized()) {
            return false;
        }
        GatewayGeneralConfiguration this$generalConfiguration = this.getGeneralConfiguration();
        GatewayGeneralConfiguration other$generalConfiguration = other.getGeneralConfiguration();
        if (this$generalConfiguration == null ? other$generalConfiguration != null : !this$generalConfiguration.equals(other$generalConfiguration)) {
            return false;
        }
        ManagedObjectRepresentation this$gatewayDevice = this.getGatewayDevice();
        ManagedObjectRepresentation other$gatewayDevice = other.getGatewayDevice();
        if (this$gatewayDevice == null ? other$gatewayDevice != null : !this$gatewayDevice.equals(other$gatewayDevice)) {
            return false;
        }
        Collection this$serverIdentifiers = this.getServerIdentifiers();
        Collection other$serverIdentifiers = other.getServerIdentifiers();
        return !(this$serverIdentifiers == null ? other$serverIdentifiers != null : !((Object)this$serverIdentifiers).equals(other$serverIdentifiers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GatewayDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFullyInitialized() ? 79 : 97);
        GatewayGeneralConfiguration $generalConfiguration = this.getGeneralConfiguration();
        result = result * 59 + ($generalConfiguration == null ? 43 : $generalConfiguration.hashCode());
        ManagedObjectRepresentation $gatewayDevice = this.getGatewayDevice();
        result = result * 59 + ($gatewayDevice == null ? 43 : $gatewayDevice.hashCode());
        Collection $serverIdentifiers = this.getServerIdentifiers();
        result = result * 59 + ($serverIdentifiers == null ? 43 : ((Object)$serverIdentifiers).hashCode());
        return result;
    }

    public String toString() {
        return "GatewayDetails(generalConfiguration=" + this.getGeneralConfiguration() + ", serverIdentifiers=" + this.getServerIdentifiers() + ", fullyInitialized=" + this.isFullyInitialized() + ")";
    }
}

