/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.repository.aggregate;

import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class DataAggregator<T extends AbstractExtensibleRepresentation> {
    protected Map<String, T> aggregatedData = new ConcurrentHashMap();

    public void aggregate(T element, Supplier<String> keySupplier, Function<T, T> aggregateFn) {
        String key = keySupplier.get();
        if (!this.aggregatedData.containsKey(key)) {
            this.remappingFirst().apply(element);
        }
        this.aggregatedData.merge(key, element, (prev, one) -> (AbstractExtensibleRepresentation)aggregateFn.apply(prev));
    }

    public void aggregate(T element) {
        this.aggregate(element, this.computeKey(element), this.remapping());
    }

    public Collection<T> getAndClear() {
        HashSet data = new HashSet(this.aggregatedData.values());
        this.aggregatedData.clear();
        return data;
    }

    protected Function<T, T> remappingFirst() {
        return firstElement -> firstElement;
    }

    protected Supplier<String> computeKey(T element) {
        return () -> element.toString();
    }

    protected Function<T, T> remapping() {
        return element -> element;
    }
}

