/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler.base;

import c8y.Command;
import c8y.ua.Node;
import c8y.ua.command.ReadFileOperation;
import c8y.ua.data.MethodArgument;
import c8y.ua.data.MethodRequest;
import c8y.ua.data.MethodResponse;
import com.cumulocity.opcua.client.NodeIds;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.operation.exception.OperationExecutionException;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationHandler;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationNodeValidator;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.OpenFileMode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class BaseReadAndUploadFileOperationHandler<T extends ReadFileOperation>
extends UAOperationHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseReadAndUploadFileOperationHandler.class);
    private static final String OPCUA_FILES = "opcua-files-";
    private static final long DEFAULT_BUFFER_SIZE = 1000000L;
    private static final long MAX_ALLOWED_BUFFER_IN_BYTES = 10000000L;
    private static final String OPCUA_FILE_TYPE = "ua-file-type";

    @Autowired
    public BaseReadAndUploadFileOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, Class<T> supportedOperationType, DeviceControlApi deviceControlApi, InventoryApi inventoryApi, UAOperationNodeValidator nodeValidator) {
        super(gatewayManager, connectionManager, supportedOperationType, deviceControlApi, inventoryApi, nodeValidator);
    }

    public HandleInternalResult handleInternal(T operation) {
        long bufferSize;
        Optional connection = this.resolveClient(operation);
        if (!connection.isPresent()) {
            return new HandleInternalResult(null, false, "Server not connected");
        }
        long l = bufferSize = Objects.isNull(operation.getBufferSize()) ? 1000000L : operation.getBufferSize();
        if (bufferSize > 10000000L) {
            log.warn("Provided buffer size is too big, using the maximum-allowed one: {} bytes", (Object)10000000L);
            bufferSize = 10000000L;
        }
        OpcuaClient client = (OpcuaClient)connection.get();
        UnsignedInteger fileHandle = this.openFileForRead(client, operation.getFileNodeId());
        try {
            int bytesRead;
            if (!operation.isSkipResetPosition()) {
                log.info("Resetting position for file: {}", (Object)operation.getFileNodeId());
                this.resetPosition(client, operation.getFileNodeId(), fileHandle);
            }
            log.info("Start reading file: {}", (Object)operation.getFileNodeId());
            Node readFileMethodNode = this.findFileMethodNode(client, operation.getFileNodeId(), "Read");
            if (Objects.isNull(readFileMethodNode)) {
                throw new OperationExecutionException(String.format("Unable to find the Read method of file: %s", operation.getFileNodeId()));
            }
            Path localFilePath = Files.createTempFile(OPCUA_FILES, null, new FileAttribute[0]);
            while ((bytesRead = this.readMore(client, operation.getFileNodeId(), readFileMethodNode, fileHandle, bufferSize, localFilePath)) > 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Read {} bytes", (Object)bytesRead);
                }
                if ((long)bytesRead >= bufferSize) continue;
            }
            log.info("Read file completed!");
            this.uploadFile(operation, localFilePath);
        }
        catch (OpcuaClientException | IOException e) {
            throw new OperationExecutionException(e);
        }
        finally {
            this.closeFile(client, operation.getFileNodeId(), fileHandle);
        }
        return new HandleInternalResult(new Command("Read file completed"), true, "");
    }

    protected UnsignedInteger openFileForRead(OpcuaClient client, String fileNodeId) throws OpcuaClientException, OperationExecutionException {
        MethodArgument output;
        log.info("Opening file for read: {}", (Object)fileNodeId);
        Node openMethodNode = this.findFileMethodNode(client, fileNodeId, "Open");
        if (Objects.isNull(openMethodNode)) {
            throw new OperationExecutionException(String.format("Unable to find the Open method of file: %s", fileNodeId));
        }
        MethodArgument mode = MethodArgument.basic((NodeId)Identifiers.Byte, (String)"Mode", (Object)OpenFileMode.Read.getValue());
        MethodResponse response = client.call(MethodRequest.rawResponse((String)fileNodeId, (String)openMethodNode.getNodeId(), (MethodArgument[])new MethodArgument[]{mode}));
        if (response.getResult().size() >= 1 && !Objects.isNull((output = (MethodArgument)response.getResult().get(0)).getRawValue())) {
            if (output.getRawValue() instanceof UnsignedInteger) {
                return (UnsignedInteger)output.getRawValue();
            }
            return UnsignedInteger.parseUnsignedInteger((String)output.getRawValue().toString());
        }
        throw new OpcuaClientException(String.format("Unable to open file, method response: %s", response));
    }

    protected void closeFile(OpcuaClient client, String fileNodeId, UnsignedInteger fileHandle) throws OpcuaClientException {
        log.info("Closing file: {}, file handle: {}", (Object)fileNodeId, (Object)fileHandle);
        Node closeMethodNode = this.findFileMethodNode(client, fileNodeId, "Close");
        if (Objects.isNull(closeMethodNode)) {
            log.warn("Unable to find Close method for file: {}", (Object)fileNodeId);
            return;
        }
        MethodArgument fileHandleArg = MethodArgument.basic((NodeId)Identifiers.UInt32, (String)"FileHandle", (Object)fileHandle);
        client.call(MethodRequest.rawResponse((String)fileNodeId, (String)closeMethodNode.getNodeId(), (MethodArgument[])new MethodArgument[]{fileHandleArg}));
    }

    protected void resetPosition(OpcuaClient client, String fileNodeId, UnsignedInteger fileHandle) throws OpcuaClientException {
        log.info("Resetting position for file: {}, file handle: {}", (Object)fileNodeId, (Object)fileHandle);
        Node setPositionMethod = this.findFileMethodNode(client, fileNodeId, "SetPosition");
        if (Objects.isNull(setPositionMethod)) {
            log.warn("Unable to find SetPosition method for file: {}, skipped resetting position", (Object)fileNodeId);
            return;
        }
        MethodArgument fileHandleArg = MethodArgument.basic((NodeId)Identifiers.UInt32, (String)"FileHandle", (Object)fileHandle.toString());
        MethodArgument position = MethodArgument.basic((NodeId)Identifiers.UInt64, (String)"Position", (Object)0);
        client.call(MethodRequest.rawResponse((String)fileNodeId, (String)setPositionMethod.getNodeId(), (MethodArgument[])new MethodArgument[]{fileHandleArg, position}));
    }

    private int readMore(OpcuaClient client, String fileNodeId, Node readMethodNode, UnsignedInteger fileHandle, long bufferSize, Path localFilePath) throws OpcuaClientException, IOException {
        MethodArgument output;
        ByteString buffer;
        MethodArgument fileHandleArg = MethodArgument.basic((NodeId)Identifiers.UInt32, (String)"FileHandle", (Object)fileHandle);
        MethodArgument lengthArg = MethodArgument.basic((NodeId)Identifiers.Int32, (String)"Length", (Object)bufferSize);
        MethodResponse response = client.call(MethodRequest.rawResponse((String)fileNodeId, (String)readMethodNode.getNodeId(), (MethodArgument[])new MethodArgument[]{fileHandleArg, lengthArg}));
        if (response.getResult().size() >= 1 && !Objects.isNull(buffer = (ByteString)(output = (MethodArgument)response.getResult().get(0)).getRawValue()) && buffer.getLength() > 0) {
            Files.write(localFilePath, buffer.getValue(), StandardOpenOption.APPEND);
            return buffer.getLength();
        }
        return 0;
    }

    protected abstract void uploadFile(T var1, Path var2) throws IOException, OperationExecutionException;

    private Node findFileMethodNode(OpcuaClient client, String nodeId, String simpleName) throws OpcuaClientException {
        Node methodNode = client.findMethodNode(nodeId, QualifiedName.parseQualifiedName((String)simpleName));
        if (Objects.isNull(methodNode)) {
            int nsIndex = NodeIds.parseNodeId((String)nodeId).getNamespaceIndex();
            methodNode = client.findMethodNode(nodeId, new QualifiedName(nsIndex, simpleName));
        }
        return methodNode;
    }

    protected Set<String> getQueryNodes(ReadFileOperation operation) {
        return operation.getFileNodeId() != null ? Set.of(operation.getFileNodeId()) : Set.of();
    }
}

