/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler;

import c8y.ua.command.ReadFileAndUploadOperation;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.operation.exception.OperationExecutionException;
import com.cumulocity.opcua.client.gateway.operation.handler.base.BaseReadAndUploadFileOperationHandler;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationNodeValidator;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReadAndUploadFileToExternalOperationHandler
extends BaseReadAndUploadFileOperationHandler<ReadFileAndUploadOperation> {
    private static final Logger log = LoggerFactory.getLogger(ReadAndUploadFileToExternalOperationHandler.class);

    @Autowired
    public ReadAndUploadFileToExternalOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, DeviceControlApi deviceControlApi, InventoryApi inventoryApi, UAOperationNodeValidator nodeValidator) {
        super(gatewayManager, connectionManager, ReadFileAndUploadOperation.class, deviceControlApi, inventoryApi, nodeValidator);
    }

    protected void uploadFile(ReadFileAndUploadOperation operation, Path localFilePath) throws IOException, OperationExecutionException {
        Object formData = operation.getProperty("formData");
        int uploadResponseStatus = 400;
        Map formDataMap = Map.of();
        if (formData != null && formData instanceof Map) {
            Map tempMap = (Map)formData;
            boolean isValid = tempMap.entrySet().stream().allMatch(entry -> entry.getKey() instanceof String && entry.getValue() instanceof String);
            if (isValid) {
                formDataMap = tempMap;
            } else {
                log.error("formData values must be from type String");
                throw new OperationExecutionException("formData values must be from type String");
            }
        }
        if ((uploadResponseStatus = this.uploadFile(operation.getFileNodeId(), localFilePath, operation.getExternalUri(), operation.getAuthorizationHeader(), operation.getConnectTimeout(), operation.getReadTimeout(), formDataMap)) >= 300) {
            throw new IOException("File upload to " + operation.getExternalUri() + " failed with status: " + uploadResponseStatus);
        }
    }

    private int uploadFile(String node, Path localFilePath, String externalUri, String authorizationHeader, Integer connectTimeout, Integer readTimeout, Map<String, String> formData) throws IOException {
        log.info("Uploading file: {} to URL: {}", (Object)node, (Object)externalUri);
        Client client = this.getClient(connectTimeout, readTimeout);
        FormDataMultiPart multiPart = new FormDataMultiPart();
        FileDataBodyPart filePart = new FileDataBodyPart("file", localFilePath.toFile());
        formData.forEach((key, value) -> multiPart.field(key, value));
        multiPart.bodyPart((BodyPart)filePart);
        WebTarget target = client.target(externalUri);
        Response response = target.request().header("Authorization", (Object)authorizationHeader).post(Entity.entity((Object)multiPart, (MediaType)multiPart.getMediaType()));
        if (response.getStatus() < 300) {
            log.info("File uploaded successfully!");
        } else {
            log.warn("File upload failed with status: {}", (Object)response.getStatus());
        }
        response.close();
        client.close();
        Files.deleteIfExists(localFilePath);
        return response.getStatus();
    }

    public Client getClient(Integer connectTimeout, Integer readTimeout) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.property("jersey.config.client.connectTimeout", (Object)(connectTimeout != null ? connectTimeout : 10000));
        clientConfig.property("jersey.config.client.readTimeout", (Object)(readTimeout != null ? readTimeout : 10000));
        clientConfig.register(MultiPartFeature.class);
        Client client = ClientBuilder.newClient((Configuration)clientConfig);
        return client;
    }
}

