/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler;

import c8y.Command;
import c8y.ua.command.BaseHistoricReadOperation;
import c8y.ua.command.HistoricReadOperation;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.history.model.HistoryValuesReadSuccessfulEvent;
import com.cumulocity.opcua.client.gateway.operation.exception.OperationExecutionException;
import com.cumulocity.opcua.client.gateway.operation.handler.base.BaseHistoricOperationHandler;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationNodeValidator;
import com.cumulocity.opcua.client.model.HistoricReadResult;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class HistoricReadOperationHandler
extends BaseHistoricOperationHandler<HistoricReadOperation> {
    private static final Logger log = LoggerFactory.getLogger(HistoricReadOperationHandler.class);
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public HistoricReadOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, DeviceControlApi deviceControlApi, ApplicationEventPublisher eventPublisher, InventoryApi inventoryApi, UAOperationNodeValidator nodeValidator) {
        super(gatewayManager, connectionManager, HistoricReadOperation.class, deviceControlApi, inventoryApi, nodeValidator);
        this.eventPublisher = eventPublisher;
    }

    protected int getDefaultBatchSize() {
        return 200;
    }

    protected HandleInternalResult handleInternal(HistoricReadOperation operation) throws OperationExecutionException {
        if (!operation.isValidTaggingType()) {
            String failureMessage = String.format("Unsupported tagging type: %s for historic read operation", operation.getTagType());
            log.error(failureMessage);
            throw new OperationExecutionException(failureMessage);
        }
        return super.handleInternal((BaseHistoricReadOperation)operation);
    }

    protected int processData(HistoricReadResult historicReadResult, HistoricReadOperation operation, int batches) {
        if (operation.isProcessMappings()) {
            return this.processMappings(historicReadResult, operation);
        }
        return 0;
    }

    protected Command onCompleted(int batches, Supplier<Object> proceededValues) {
        Command command = new Command();
        command.setResult(String.format("%s historic read values are processed", proceededValues.get()));
        return command;
    }

    private int processMappings(HistoricReadResult historicReadResult, HistoricReadOperation operation) {
        HistoryValuesReadSuccessfulEvent event = new HistoryValuesReadSuccessfulEvent(operation.getDeviceId().getValue(), operation.getNodeId(), historicReadResult.getDataValues(), Boolean.valueOf(operation.useTagging()));
        log.info("Publishing HistoryReadValuesReadSuccessfulEvent");
        this.eventPublisher.publishEvent((Object)event);
        return Objects.isNull(historicReadResult.getDataValues()) ? 0 : historicReadResult.getDataValues().length;
    }

    protected Set<String> getQueryNodes(HistoricReadOperation operation) {
        return operation.getNodeId() != null ? Set.of(operation.getNodeId()) : Set.of();
    }
}

