/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappings;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.mappings.DeviceTypeRepository;
import com.cumulocity.opcua.client.gateway.subscription.DeviceTypeConverter;
import com.cumulocity.opcua.common.model.mapping.DeviceType;
import com.cumulocity.opcua.common.repository.InventoryRepository;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.QueryParam;
import com.cumulocity.sdk.client.inventory.InventoryFilter;
import com.cumulocity.sdk.client.inventory.PagedManagedObjectCollectionRepresentation;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeviceTypeRepository {
    @Autowired
    private InventoryRepository inventoryRepository;

    public Map<String, DeviceType> getAllDeviceTypes() {
        InventoryFilter filter = new InventoryFilter().byType("c8y_OpcuaDeviceType").byFragmentType(DeviceType.class);
        LinkedList allDeviceTypesMOs = Lists.newLinkedList((Iterable)((PagedManagedObjectCollectionRepresentation)this.inventoryRepository.getManagedObjectsByFilter(filter).get(1000, new QueryParam[0])).allPages());
        return DeviceTypeConverter.toDeviceTypeMap((List)allDeviceTypesMOs);
    }

    public List<ManagedObjectRepresentation> getDeviceTypeMOsUpdatedAfter(DateTime dateFrom) {
        LinkedList deviceTypesMOs = Lists.newLinkedList((Iterable)((PagedManagedObjectCollectionRepresentation)this.inventoryRepository.getManagedObjects().get(1000, new QueryParam[]{new DeviceTypeQueryParamDateFrom(dateFrom)})).allPages());
        return deviceTypesMOs;
    }

    public Integer getAllDeviceTypeCount() {
        InventoryFilter filter = new InventoryFilter().byType("c8y_OpcuaDeviceType").byFragmentType(DeviceType.class);
        Integer count = this.inventoryRepository.countManagedObjectsByFilter(filter);
        return count;
    }

    public DeviceType getDeviceType(String deviceTypeId) {
        ManagedObjectRepresentation deviceTypeMO = this.inventoryRepository.get(GId.asGId((String)deviceTypeId));
        return DeviceTypeConverter.toDeviceType((ManagedObjectRepresentation)deviceTypeMO);
    }
}

