/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.identitiy;

import c8y.ua.IdentityConfig;
import com.cumulocity.opcua.client.IdentityTools;
import com.cumulocity.opcua.client.gateway.encryption.EncryptionService;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.utils.CertificateUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class IdentityToolsImpl
implements IdentityTools {
    private static final Logger log = LoggerFactory.getLogger(IdentityToolsImpl.class);
    @Value(value="${gateway.applicationIdentity.validityTime:3650}")
    private int validityTime;
    @Autowired
    private EncryptionService encryptionService;

    public IdentityConfig generateApplicationIdentityConfig() throws IOException, GeneralSecurityException {
        IdentityConfig cfg = new IdentityConfig();
        KeyPair kp = CertificateUtils.createApplicationInstanceCertificate((String)"cumulocity-opcua-gateway", (String)"cumulocity", (String)"urn:cumulocity:opcua:gateway", (int)this.validityTime, (String[])new String[0]);
        cfg.setCert(new String(Base64.getEncoder().encode(kp.getCertificate().getEncoded())));
        cfg.setPk((String)this.encryptPrivateKey(kp.getPrivateKey().getEncodedPrivateKey()).orElseThrow(GeneralSecurityException::new));
        cfg.setPkIsAESGCMEncrypted(Boolean.TRUE);
        return cfg;
    }

    public Optional<String> encryptPrivateKey(byte[] privateKey) {
        try {
            return Optional.of(EncryptionService.encryptAESGCM((String)this.encryptionService.fetchSecret(), (String)this.encryptionService.fetchSalt(), (String)this.encryptionService.fetchIv(), (byte[])privateKey));
        }
        catch (Exception ex) {
            log.error("Error while encrypting private key");
            return Optional.empty();
        }
    }
}

