/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.bootstrap.service;

import com.cumulocity.model.ID;
import com.cumulocity.opcua.client.gateway.bootstrap.model.CredentialsAvailableEvent;
import com.cumulocity.opcua.client.gateway.bootstrap.model.DeviceCredentials;
import com.cumulocity.opcua.client.gateway.bootstrap.service.BootstrapService;
import com.cumulocity.opcua.client.gateway.configuration.GatewayGeneralConfiguration;
import com.cumulocity.opcua.client.gateway.datastore.GatewayLocalDatabase;
import com.cumulocity.opcua.client.gateway.jmx.ServerMonitoringMBean;
import com.cumulocity.opcua.client.gateway.platform.configuration.PlatformFactoryBootstrap;
import com.cumulocity.opcua.client.gateway.platform.configuration.PlatformProvider;
import com.cumulocity.opcua.client.gateway.platform.configuration.condition.PlatformStandaloneCondition;
import com.cumulocity.opcua.client.gateway.platform.factory.ManagedObjectFactory;
import com.cumulocity.opcua.client.gateway.platform.repository.IdentityRepository;
import com.cumulocity.opcua.common.repository.InventoryRepository;
import com.cumulocity.rest.representation.devicebootstrap.DeviceCredentialsRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.SDKException;
import com.cumulocity.sdk.client.option.SystemOptionApi;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"platformFactoryStandard", "platformFactoryBootstrap"})
@Conditional(value={PlatformStandaloneCondition.class})
public class BootstrapServiceStandAlone
extends BootstrapService
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(BootstrapServiceStandAlone.class);
    private final TaskScheduler scheduler;
    private final PlatformProvider platformProvider;
    private final GatewayLocalDatabase db;
    @Autowired
    PlatformFactoryBootstrap platformFactoryBootstrap;

    public BootstrapServiceStandAlone(ServerMonitoringMBean mbean, GatewayGeneralConfiguration configuration, ApplicationEventPublisher eventPublisher, IdentityRepository identityRepository, InventoryRepository inventoryRepository, SystemOptionApi systemOptionApi, TaskScheduler scheduler, PlatformProvider platformProvider, GatewayLocalDatabase db) {
        super(mbean, configuration, eventPublisher, identityRepository, inventoryRepository, systemOptionApi);
        this.scheduler = scheduler;
        this.platformProvider = platformProvider;
        this.db = db;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.scheduleDeviceCredentialsPoll();
    }

    protected void onInvalidCredentials() {
        log.error("Invalid device credentials detected! Removing local cached credentials...");
        this.db.setCredentials(null);
        log.info("Local credentials removed! Please bootstrap the device agent again. \n Shutting down platform...");
    }

    protected ManagedObjectRepresentation createDevice(ID deviceId) {
        ManagedObjectRepresentation deviceMO = this.inventoryRepository.create(ManagedObjectFactory.create((String)this.configuration.getGatewayName()));
        log.info("Device created with ID: {}", (Object)deviceMO.getId().getValue());
        this.identityRepository.create(deviceId, deviceMO.getId());
        return deviceMO;
    }

    private void scheduleDeviceCredentialsPoll() {
        this.scheduler.scheduleWithFixedDelay(() -> {
            DeviceCredentials deviceCredentials;
            if (this.platformProvider.isPlatformConfigured()) {
                return;
            }
            log.info("Polling device credentials...");
            Optional<DeviceCredentials> credentialsOptional = Optional.ofNullable(this.db.getCredentials());
            if (credentialsOptional.isPresent() && !this.configuration.isForcedBootstrap()) {
                log.info("Credentials available locally, take it.");
                deviceCredentials = credentialsOptional.get();
            } else {
                log.info("Credentials is not available locally or bootstrap is forced, polling from server..");
                deviceCredentials = this.pollDeviceCredentials();
            }
            if (!Objects.isNull(deviceCredentials)) {
                log.info("Obtained device credentials");
                this.eventPublisher.publishEvent((Object)new CredentialsAvailableEvent(deviceCredentials));
            }
        }, this.configuration.getBootstrapConfig().getBootstrapDelay().longValue());
    }

    private DeviceCredentials pollDeviceCredentials() {
        DeviceCredentials deviceCredentials = null;
        try {
            DeviceCredentialsRepresentation newDeviceCredentials = this.platformFactoryBootstrap.getBootstrapPlatform().getDeviceCredentialsApi().pollCredentials(this.configuration.getGatewayIdentifier());
            deviceCredentials = new DeviceCredentials(newDeviceCredentials.getTenantId(), newDeviceCredentials.getUsername(), newDeviceCredentials.getPassword());
            this.db.setCredentials(deviceCredentials);
            return deviceCredentials;
        }
        catch (SDKException e) {
            if (e.getHttpStatus() != 404) {
                throw e;
            }
            log.warn("There is no newDeviceRequest or deviceRequest has not been accepted for device id {}. Please register device manually under Device Management UI", (Object)this.configuration.getGatewayIdentifier());
            return deviceCredentials;
        }
    }

    void setPlatformFactoryBootstrap(PlatformFactoryBootstrap platformFactoryBootstrap) {
        this.platformFactoryBootstrap = platformFactoryBootstrap;
    }
}

