/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.configuration;

import com.cumulocity.model.authentication.CumulocityCredentials;
import com.cumulocity.opcua.client.gateway.platform.configuration.BasePlatformFactory;
import com.cumulocity.opcua.client.gateway.platform.configuration.PlatformProvider;
import com.cumulocity.opcua.client.gateway.platform.configuration.condition.PlatformThinEdgeProxyCondition;
import com.cumulocity.opcua.client.gateway.platform.model.authentication.CumulocityAnonymousCredentials;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={PlatformThinEdgeProxyCondition.class})
public class PlatformFactoryThinEdgeProxy
extends BasePlatformFactory
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(PlatformFactoryThinEdgeProxy.class);
    @Value(value="${gateway.thinEdge.deviceId}")
    private String thinEdgeDeviceId;
    private String thinEdgeDeviceOwner;
    @Autowired
    private PlatformProvider platformProvider;

    public void afterPropertiesSet() throws Exception {
        log.info("ThinEdge Proxy PlatformFactory is loading...");
        this.thinEdgeDeviceOwner = String.format("device_%s", this.thinEdgeDeviceId);
    }

    @EventListener
    public void onContextRefresh(ContextRefreshedEvent contextRefreshedEvent) {
        if (this.platformProvider.isPlatformConfigured()) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.thinEdgeDeviceOwner)) {
            this.platform = this.initializePlatformWithCredentials((CumulocityCredentials)new CumulocityAnonymousCredentials());
            this.configurePlatform(this.thinEdgeDeviceOwner);
            log.info("ThinEdge Proxy PlatformFactory is configured");
        }
    }

    public void setThinEdgeDeviceId(String thinEdgeDeviceId) {
        this.thinEdgeDeviceId = thinEdgeDeviceId;
    }
}

