/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.configuration;

import com.cumulocity.model.authentication.CumulocityCredentials;
import com.cumulocity.opcua.client.gateway.configuration.GatewayGeneralConfiguration;
import com.cumulocity.opcua.client.gateway.platform.model.PlatformConfiguredEvent;
import com.cumulocity.opcua.client.gateway.platform.repository.interceptor.ProcessingModeHttpInterceptor;
import com.cumulocity.sdk.client.ConnectionPoolConfig;
import com.cumulocity.sdk.client.HttpClientConfig;
import com.cumulocity.sdk.client.Platform;
import com.cumulocity.sdk.client.PlatformBuilder;
import com.cumulocity.sdk.client.PlatformImpl;
import com.cumulocity.sdk.client.interceptor.HttpClientInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;

abstract class BasePlatformFactory {
    @Value(value="${gateway.platform.connectionPool.max}")
    private Integer platformConnectionPoolMax;
    @Value(value="${gateway.platform.connectionPool.perHost}")
    private Integer platformConnectionPoolPerHost;
    @Value(value="${C8Y.proxyHost:}")
    String proxyHost;
    @Value(value="${C8Y.proxyPort:}")
    Integer proxyPort;
    @Value(value="${C8Y.proxyUser:}")
    String proxyUser;
    @Value(value="${C8Y.proxyPassword:}")
    String proxyPassword;
    @Autowired
    GatewayGeneralConfiguration gatewayGeneralConfiguration;
    @Autowired
    ApplicationEventPublisher eventPublisher;
    Platform platform;

    BasePlatformFactory() {
    }

    public Platform initializePlatformWithCredentials(CumulocityCredentials credentials) {
        Platform platform = PlatformBuilder.platform().withBaseUrl(this.gatewayGeneralConfiguration.getBaseUrl()).withForceInitialHost(this.gatewayGeneralConfiguration.isForceInitialHost()).withCredentials(credentials).withProxyHost(this.proxyHost).withProxyPort(this.proxyPort).build();
        PlatformImpl platformImpl = (PlatformImpl)platform;
        platformImpl.setProxyPassword(this.proxyPassword);
        platformImpl.setProxyUserId(this.proxyUser);
        return platformImpl;
    }

    public void configurePlatform(String userName) {
        ((PlatformImpl)this.platform).setHttpClientConfig(HttpClientConfig.httpConfig().pool(ConnectionPoolConfig.connectionPool().enabled(true).max(this.platformConnectionPoolMax.intValue()).perHost(this.platformConnectionPoolPerHost.intValue()).build()).build());
        ((PlatformImpl)this.platform).registerInterceptor((HttpClientInterceptor)new ProcessingModeHttpInterceptor());
        this.eventPublisher.publishEvent((Object)new PlatformConfiguredEvent(this.platform, userName));
    }

    public void setPlatformConnectionPoolMax(Integer platformConnectionPoolMax) {
        this.platformConnectionPoolMax = platformConnectionPoolMax;
    }

    public void setPlatformConnectionPoolPerHost(Integer platformConnectionPoolPerHost) {
        this.platformConnectionPoolPerHost = platformConnectionPoolPerHost;
    }
}

