/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler.base;

import c8y.ua.command.BaseOperation;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.gateway.operation.handler.base.OperationHandler;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UAServerOperationHandler<T extends BaseOperation>
extends OperationHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(UAServerOperationHandler.class);
    protected final ConnectionManager connectionManager;
    protected final GatewayManager gatewayManager;

    public UAServerOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, Class<T> supportedOperationType, DeviceControlApi deviceControlApi) {
        super(deviceControlApi, supportedOperationType);
        this.gatewayManager = gatewayManager;
        this.connectionManager = connectionManager;
    }

    protected Optional<OpcuaClient> resolveClient(T operation) {
        return this.connectionManager.getConnection(new ServerIdentifier(operation.getDeviceId()));
    }

    protected HandleInternalResult failWithReason(String reason) {
        HandleInternalResult result = new HandleInternalResult();
        result.setSuccessful(false);
        result.setFailureReason(reason);
        return result;
    }
}

