/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.tasks;

import com.cumulocity.model.event.CumulocitySeverities;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.BaseBatchTask;
import com.cumulocity.opcua.client.gateway.platform.repository.ThinEdgeAlarmRepository;
import com.cumulocity.opcua.client.serialization.OpcuaSerializer;
import com.cumulocity.opcua.common.model.mapping.action.HttpPostAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ThinEdgeBatchCustomActionTask
extends BaseBatchTask {
    private static final Logger log = LoggerFactory.getLogger(ThinEdgeBatchCustomActionTask.class);
    @Autowired
    private MqttClient mqttClient;
    @Autowired
    private ThinEdgeAlarmRepository alarmRepository;

    public void run() {
        try {
            String topic = null;
            ArrayList payloads = new ArrayList();
            for (String nodeId : this.getBatchActions().keySet()) {
                Collection actions = (Collection)this.getBatchActions().get(nodeId);
                payloads.addAll(actions.stream().filter(a -> a instanceof HttpPostAction).map(a -> this.payload((HttpPostAction)a, nodeId)).collect(Collectors.toList()));
                topic = actions.stream().filter(a -> a instanceof HttpPostAction).map(a -> ((HttpPostAction)a).getEndpoint()).findFirst().orElse(topic);
            }
            if (topic != null && !topic.isEmpty()) {
                MqttMessage message = new MqttMessage();
                message.setPayload(("[" + String.join((CharSequence)",", payloads) + "]").getBytes());
                this.mqttClient.publish(topic, message);
            }
        }
        catch (MqttException e) {
            this.alarmRepository.create(this.getDeviceId(), "opcuaMqttPublishFailed", CumulocitySeverities.MAJOR.name(), "Failed to publish MQTT message: " + e.getMessage());
            log.error("Failed to publish MQTT message: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private String payload(HttpPostAction customAction, String nodeId) {
        return customAction.getBodyTemplate().replaceAll("\\$\\{value}", OpcuaSerializer.getInstance().toJson(this.getEvent().getValues().get(nodeId))).replaceAll("\\$\\{serverId}", this.getEvent().getServerId()).replaceAll("\\$\\{nodeId}", nodeId).replaceAll("\\$\\{deviceId}", this.getDeviceId().getValue()).replaceAll("\\$\\{receivedTimestampInMs}", String.valueOf(DateTime.now().getMillis()));
    }

    public void setMqttClient(MqttClient mqttClient) {
        this.mqttClient = mqttClient;
    }

    public void setAlarmRepository(ThinEdgeAlarmRepository alarmRepository) {
        this.alarmRepository = alarmRepository;
    }
}

