/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.tasks;

import com.cumulocity.model.event.CumulocityAlarmStatuses;
import com.cumulocity.model.event.CumulocitySeverities;
import com.cumulocity.opcua.client.gateway.mappingsexecution.exception.InvalidDataTypeException;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.BaseDataValueEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.C8YBaseTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.TaskUtils;
import com.cumulocity.opcua.client.gateway.platform.repository.AlarmRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.BaseQueuedRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.interceptor.ProcessingModeContext;
import com.cumulocity.opcua.common.model.mapping.action.AlarmCreation;
import com.cumulocity.opcua.common.model.mapping.action.MappingAction;
import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import com.cumulocity.rest.representation.alarm.AlarmRepresentation;
import com.cumulocity.sdk.client.ProcessingMode;
import com.cumulocity.sdk.client.alarm.AlarmFilter;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class AlarmCreationTask
extends C8YBaseTask<AlarmRepresentation, AlarmRepresentation> {
    private static final Logger log = LoggerFactory.getLogger(AlarmCreationTask.class);
    private AlarmCreation alarmCreation;
    @Autowired
    private AlarmRepository alarmRepository;
    @Autowired
    private ProcessingModeContext processingModeContext;

    public void run() {
        BaseDataValueEvent event = this.getEvent();
        if (this.isDataValueBad()) {
            return;
        }
        log.debug("Creating alarm for " + event.getServerId() + ":" + event.getNodeId() + " ## " + String.valueOf(this.alarmCreation));
        boolean active = this.getBooleanValue(event.getValue());
        if (active) {
            AlarmRepresentation alarmRepresentation = this.alarmRepository.buildAlarm(this.getDeviceId(), this.alarmCreation.getType(), this.alarmCreation.getSeverity(), this.alarmCreation.getText(), this.getDateTimeWithFallBack(event));
            alarmRepresentation.setProperty("c8y_ua_SourceNodeId_" + event.getNodeId(), new HashMap());
            TaskUtils.populateStaticFragments((MappingAction)this.alarmCreation, (AbstractExtensibleRepresentation)alarmRepresentation);
            this.addToQueue((AbstractExtensibleRepresentation)alarmRepresentation);
        } else {
            AlarmFilter filter = new AlarmFilter().byType(this.alarmCreation.getType()).bySource(this.getDeviceId()).byStatus(new CumulocityAlarmStatuses[]{CumulocityAlarmStatuses.ACTIVE}).byResolved(Boolean.valueOf(false));
            this.clearAlarmsByFilter(filter);
        }
    }

    private void clearAlarmsByFilter(AlarmFilter filter) {
        if (this.getProcessingMode().isPresent()) {
            this.processingModeContext.executeInPMContext((ProcessingMode)this.getProcessingMode().get(), () -> this.alarmRepository.clearAlarmsByFilter(filter));
        } else {
            this.alarmRepository.clearAlarmsByFilter(filter);
        }
    }

    boolean getBooleanValue(DataValue value) {
        Object obj = value.getValue().getValue();
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue() > 0;
        }
        if (obj instanceof String) {
            return Boolean.parseBoolean((String)obj);
        }
        String errorMessage = "Invalid data type in OPC-UA alarm mapping:\n  nodeId: " + this.getEvent().getNodeId() + "\n  serverId: " + this.getEvent().getServerId() + "\n  received type: " + obj.getClass().getName();
        this.alarmRepository.create(this.getDeviceId(), "opcuaInvalidMappingDataType", CumulocitySeverities.MAJOR.name(), errorMessage);
        throw new InvalidDataTypeException("Can't parse " + obj.getClass().getName() + " into boolean");
    }

    protected BaseQueuedRepository<AlarmRepresentation, AlarmRepresentation> getRepository() {
        return this.alarmRepository;
    }

    public void setAlarmCreation(AlarmCreation alarmCreation) {
        this.alarmCreation = alarmCreation;
    }

    public void setAlarmRepository(AlarmRepository alarmRepository) {
        this.alarmRepository = alarmRepository;
    }

    public void setProcessingModeContext(ProcessingModeContext processingModeContext) {
        this.processingModeContext = processingModeContext;
    }
}

