/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.encryption;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class RandomVariablesService {
    private SecureRandom secureRandom = new SecureRandom();

    public Stream<Character> getRandomSpecialChars(int count) throws NoSuchAlgorithmException {
        IntStream specialChars = this.secureRandom.ints(count, 33, 45);
        return specialChars.mapToObj(data -> Character.valueOf((char)data));
    }

    public Stream<Character> getRandomNumbers(int count) throws NoSuchAlgorithmException {
        IntStream numbers = this.secureRandom.ints(count, 48, 57);
        return numbers.mapToObj(data -> Character.valueOf((char)data));
    }

    public Stream<Character> getRandomAlphabets(int count, boolean upperCase) throws NoSuchAlgorithmException {
        IntStream characters = upperCase ? this.secureRandom.ints(count, 65, 90) : this.secureRandom.ints(count, 97, 122);
        return characters.mapToObj(data -> Character.valueOf((char)data));
    }

    public String generateSecureRandomPassword(int numbers, int special, int upper, int lower) throws NoSuchAlgorithmException {
        Stream pwdStream = Stream.concat(this.getRandomNumbers(numbers), Stream.concat(this.getRandomSpecialChars(special), Stream.concat(this.getRandomAlphabets(upper, true), this.getRandomAlphabets(lower, false))));
        List charList = pwdStream.collect(Collectors.toList());
        Collections.shuffle(charList);
        return charList.stream().collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
    }

    public byte[] generateIv(int length) throws NoSuchAlgorithmException {
        byte[] iv = new byte[length];
        this.secureRandom.nextBytes(iv);
        return iv;
    }
}

