/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.connection;

import c8y.ua.ClientConfig;
import c8y.ua.IdentityConfig;
import c8y.ua.data.DeviceTypeMappedNodeCollection;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.SecurityModeParser;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.configuration.GatewayGeneralConfiguration;
import com.cumulocity.opcua.client.gateway.configuration.InventoryUpdateProcessingModeConfiguration;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.connection.exception.OpcuaConnectionException;
import com.cumulocity.opcua.client.gateway.connection.model.ConnectionEstablishedEvent;
import com.cumulocity.opcua.client.gateway.connection.model.NamespaceTableChangedEvent;
import com.cumulocity.opcua.client.gateway.connection.model.ServerConnectedEvent;
import com.cumulocity.opcua.client.gateway.connection.model.ServerConnectionDroppedEvent;
import com.cumulocity.opcua.client.gateway.connection.model.ServerConnectionFailedEvent;
import com.cumulocity.opcua.client.gateway.connection.model.ServerDisconnectedEvent;
import com.cumulocity.opcua.client.gateway.connection.security.KeystoreRetriever;
import com.cumulocity.opcua.client.gateway.encryption.EncryptionService;
import com.cumulocity.opcua.client.gateway.exception.ServerNotConnectedException;
import com.cumulocity.opcua.client.gateway.jmx.ServerMonitoringMBean;
import com.cumulocity.opcua.client.gateway.monitoring.OpcuaServerStateChangeListener;
import com.cumulocity.opcua.client.gateway.platform.configuration.PlatformProvider;
import com.cumulocity.opcua.client.gateway.platform.repository.MappedNodesRepository;
import com.cumulocity.opcua.client.listener.OpcuaClientListener;
import com.cumulocity.opcua.common.repository.InventoryRepository;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.UserTokenType;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import jakarta.annotation.PreDestroy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(ConnectionManager.class);
    @Autowired
    private EncryptionService encryptionService;
    @Autowired
    private PlatformProvider platformProvider;
    @Autowired
    private ApplicationContext context;
    private Map<ServerIdentifier, ClientWithConfig> clientMap = new ConcurrentHashMap();
    @Autowired
    @Qualifier(value="pmAwareInventoryRepository")
    private InventoryRepository inventoryRepository;
    @Autowired
    @Qualifier(value="mappedNodesRepository")
    private MappedNodesRepository mappedNodesRepository;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private KeystoreRetriever keystoreRetriever;
    @Autowired
    private ServerMonitoringMBean mbean;
    @Autowired
    private GatewayGeneralConfiguration gatewayGeneralConfiguration;
    @Autowired
    private InventoryUpdateProcessingModeConfiguration processingModeConfiguration;

    public OpcuaClient connect(ServerIdentifier serverIdentifier, ClientConfig clientConfig) throws OpcuaConnectionException {
        IdentityConfig applicationIdentity;
        String passwordSafe = clientConfig.getUserPassword();
        String secret = this.encryptionService.fetchSecret();
        String salt = this.encryptionService.fetchSalt();
        String iv = this.encryptionService.fetchIv();
        log.info("Configuring connection to OPC-UA Server: {}", (Object)serverIdentifier.getName());
        Boolean endpointValidation = this.gatewayGeneralConfiguration.getValidateDiscoveredEndpoints();
        endpointValidation = Objects.nonNull(clientConfig.getValidateDiscoveredEndpoints()) ? clientConfig.getValidateDiscoveredEndpoints() : endpointValidation;
        log.info("Endpoint validation: Global setting {} / Server setting {} ==>  {}", new Object[]{this.getLabel(this.gatewayGeneralConfiguration.getValidateDiscoveredEndpoints()), this.getLabel(clientConfig.getValidateDiscoveredEndpoints()), this.getLabel(endpointValidation)});
        try {
            GatewayManager gatewayManager = (GatewayManager)this.context.getBean(GatewayManager.class);
            applicationIdentity = gatewayManager.getApplicationIdentity();
        }
        catch (Exception e) {
            log.error("Error getting gateways application identity");
            throw new OpcuaConnectionException((Throwable)e);
        }
        SecurityMode securityMode = SecurityModeParser.parse((String)clientConfig.getSecurityMode());
        this.mbean.addServer(serverIdentifier.getName(), clientConfig);
        OpcuaClient client = (OpcuaClient)this.context.getBean(OpcuaClient.class);
        if (Objects.isNull(clientConfig.getPasswordEncrypted())) {
            clientConfig.setPasswordEncrypted(Boolean.valueOf(false));
        } else if (clientConfig.getPasswordEncrypted().booleanValue()) {
            try {
                passwordSafe = clientConfig.getUserPassword();
                clientConfig.setUserPassword(new String(EncryptionService.decryptAESGCM((String)secret, (String)salt, (String)iv, (String)passwordSafe)));
            }
            catch (Exception ex) {
                log.error("Problems while trying to decrypt, cause: {}", (Object)ex.getMessage());
            }
        }
        if (UserTokenType.Certificate.toString().equalsIgnoreCase(clientConfig.getUserIdentityMode())) {
            IdentityConfig userIdentity;
            log.info("New client config with Certificate");
            try {
                userIdentity = this.getUserIdentity(clientConfig);
            }
            catch (Exception e) {
                log.error("Error reading user identity from client config!");
                throw new OpcuaConnectionException((Throwable)e);
            }
            client.configure(clientConfig.getServerUrl(), securityMode, clientConfig.getUserIdentityMode(), applicationIdentity, userIdentity, clientConfig.getTimeout(), clientConfig.getStatusCheckInterval(), clientConfig.isAutoReconnect(), clientConfig.getMaxResponseMessageSize(), endpointValidation);
        } else if (!UserTokenType.IssuedToken.toString().equals(clientConfig.getUserIdentityMode())) {
            log.info("New client config with userName or Anonymous");
            client.configure(clientConfig.getServerUrl(), securityMode, clientConfig.getUserIdentityMode(), clientConfig.getUserName(), clientConfig.getUserPassword(), applicationIdentity, clientConfig.getTimeout(), clientConfig.getStatusCheckInterval(), clientConfig.isAutoReconnect(), clientConfig.getMaxResponseMessageSize(), endpointValidation);
        } else {
            log.error("Not supported UserIdentityMode {} used", (Object)clientConfig.getUserIdentityMode());
            throw new OpcuaConnectionException(new Throwable("Not supported UserIdentityMode" + clientConfig.getUserIdentityMode() + "used"));
        }
        OpcuaServerStateChangeListener serverStatusListener = (OpcuaServerStateChangeListener)this.context.getBean(OpcuaServerStateChangeListener.class, new Object[]{serverIdentifier, this.mbean});
        if (!"disabled".equals(clientConfig.getTargetConnectionState())) {
            try {
                client.connect((OpcuaClientListener)serverStatusListener);
                log.info("Connection is being established to server: {}", (Object)serverIdentifier);
            }
            catch (Exception e) {
                log.error("Connection to server {} failed, cause {}.", (Object)serverIdentifier.getName(), (Object)e.getMessage());
                this.mbean.increaseFailedConnectionAttemptsForServer(serverIdentifier.getName());
                this.eventPublisher.publishEvent((Object)new ServerConnectionFailedEvent(serverIdentifier, e.getMessage()));
                throw new OpcuaConnectionException((Throwable)e);
            }
            log.info("Connected to server {} successfully", (Object)serverIdentifier);
        }
        if (clientConfig.getPasswordEncrypted().booleanValue()) {
            client.setUserPassword(passwordSafe);
        } else if (this.platformProvider.isPlatformConfigured()) {
            try {
                if (StringUtils.isNotEmpty((String)client.getUserPassword())) {
                    clientConfig.setUserPassword(EncryptionService.encryptAESGCM((String)secret, (String)salt, (String)iv, (byte[])clientConfig.getUserPassword().getBytes()));
                    clientConfig.setPasswordEncrypted(Boolean.valueOf(true));
                    log.info("Encrypted password set");
                }
                ManagedObjectRepresentation serverMO = new ManagedObjectRepresentation();
                serverMO.set((Object)clientConfig, "c8y_ua_ClientConfig");
                serverMO.setId(serverIdentifier.getInventoryIdentifier());
                this.inventoryRepository.update(serverMO, this.processingModeConfiguration.getServerUpdateProcessingMode());
                log.info("Inventory updated with new password");
            }
            catch (Exception ex) {
                log.error("Problems while trying to encrypt, cause: {}", (Object)ex.getMessage());
            }
        }
        if (!"disabled".equals(clientConfig.getTargetConnectionState())) {
            this.clientMap.put(serverIdentifier, ClientWithConfig.from((OpcuaClient)client, (ClientConfig)clientConfig));
            this.eventPublisher.publishEvent((Object)new ServerConnectedEvent(serverIdentifier, clientConfig));
        }
        return client;
    }

    public int clientMapSize() {
        return this.clientMap.size();
    }

    public OpcuaClient getClient(String serverId) throws ServerNotConnectedException {
        Optional connection = this.getConnection(new ServerIdentifier(GId.asGId((String)serverId)));
        if (connection.isEmpty()) {
            throw new ServerNotConnectedException(serverId);
        }
        return (OpcuaClient)connection.get();
    }

    private IdentityConfig getUserIdentity(ClientConfig clientConfig) throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException, UnrecoverableKeyException {
        IdentityConfig identity = new IdentityConfig();
        if (clientConfig.getKeystoreBinaryId() != null) {
            byte[] keystore = this.keystoreRetriever.readKeystoreFromBinary(clientConfig.getKeystoreBinaryId());
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new ByteArrayInputStream(keystore), clientConfig.getKeystorePass().toCharArray());
            if (!ks.containsAlias("opcuauser")) {
                throw new CertificateException("Keystore doesn't contain certificate with alias: opcuauser");
            }
            Certificate certificate = ks.getCertificate("opcuauser");
            identity.setCert(new String(Base64.getEncoder().encode(certificate.getEncoded())));
            Key privateKey = ks.getKey("opcuauser", clientConfig.getCertificatePass().toCharArray());
            identity.setPk(new String(Base64.getEncoder().encode(privateKey.getEncoded())));
            identity.setPassword(clientConfig.getCertificatePass());
        }
        return identity;
    }

    public boolean isServerConnected(ServerIdentifier serverIdentifier) {
        return this.clientMap.containsKey(serverIdentifier);
    }

    public Collection<ServerIdentifier> getAllServerIdentifiers() {
        return this.clientMap.keySet();
    }

    public OpcuaClient getOrConnect(ServerIdentifier serverIdentifier, ClientConfig clientConfig) throws OpcuaConnectionException {
        if (this.isServerConnected(serverIdentifier)) {
            log.debug("Server already connected: " + String.valueOf(serverIdentifier));
            return ((ClientWithConfig)this.clientMap.get((Object)serverIdentifier)).client;
        }
        return this.connect(serverIdentifier, clientConfig);
    }

    public Optional<OpcuaClient> getConnection(ServerIdentifier serverIdentifier) {
        return this.clientMap.containsKey(serverIdentifier) ? Optional.of(((ClientWithConfig)this.clientMap.get((Object)serverIdentifier)).client) : Optional.empty();
    }

    public Optional<ClientConfig> getClientConfig(ServerIdentifier serverIdentifier) {
        return this.clientMap.containsKey(serverIdentifier) ? Optional.of(((ClientWithConfig)this.clientMap.get((Object)serverIdentifier)).config) : Optional.empty();
    }

    public void disconnect(ServerIdentifier serverIdentifier) {
        log.info("Disconnecting from server: {}", (Object)serverIdentifier);
        ClientWithConfig clientWithConfig = (ClientWithConfig)this.clientMap.remove(serverIdentifier);
        if (Objects.isNull(clientWithConfig)) {
            return;
        }
        OpcuaClient client = clientWithConfig.client;
        if (client.isConnected()) {
            this.disconnect(client);
        } else {
            log.info("Client was already disconnected, skipping client disconnection.");
        }
        try {
            this.eventPublisher.publishEvent((Object)new ServerDisconnectedEvent(serverIdentifier));
        }
        catch (Exception ex) {
            log.warn("Unable to publish event on server disconnected", (Throwable)ex);
        }
        this.mbean.removeServer(serverIdentifier.getName());
        log.info("Disconnected from server: {}", (Object)serverIdentifier);
    }

    public void removeServerFromLocal(ServerIdentifier serverIdentifier) {
        this.mappedNodesRepository.delete(serverIdentifier.getInventoryIdentifier().getValue());
        log.info("Removed server: {} from local storage", (Object)serverIdentifier);
    }

    @EventListener
    public void onConnectionDropped(ServerConnectionDroppedEvent droppedEvent) {
        OpcuaClient client;
        Optional connectionMaybe = this.getConnection(ServerIdentifier.of((String)droppedEvent.getServerId()));
        if (connectionMaybe.isPresent() && !(client = (OpcuaClient)connectionMaybe.get()).isAutoReconnect()) {
            log.info("Auto reconnect is OFF on server {}, client SDK won't try to reconnect", (Object)droppedEvent.getServerId());
            if (this.isTriggerManualReconnectOnConnectionDropEnabled()) {
                log.info("Triggering manual reconnect to server: {}", (Object)droppedEvent.getServerId());
                try {
                    boolean sessionChanged = ((OpcuaClient)connectionMaybe.get()).reconnect();
                    log.info("Server connection reestablished: {}, new session: {}", (Object)droppedEvent.getServerId(), (Object)sessionChanged);
                    this.eventPublisher.publishEvent((Object)new ConnectionEstablishedEvent(droppedEvent.getServerId(), (NodeId)((OpcuaClient)connectionMaybe.get()).getSessionId().orElse(null), sessionChanged));
                }
                catch (Exception e) {
                    log.error("Unable to reconnect to server: {}", (Object)droppedEvent.getServerId(), (Object)e);
                }
            } else {
                log.info("Gateway is not configured to trigger manual reconnect.");
            }
        }
    }

    public boolean isTriggerManualReconnectOnConnectionDropEnabled() {
        return Objects.isNull(this.gatewayGeneralConfiguration.getTriggerManualReconnectOnConnectionDrop()) || this.gatewayGeneralConfiguration.getTriggerManualReconnectOnConnectionDrop() != false;
    }

    @EventListener
    public void onConnectionEstablished(ConnectionEstablishedEvent reconnectedEvent) {
        Optional connectionMaybe = this.getConnection(ServerIdentifier.of((String)reconnectedEvent.getServerId()));
        try {
            if (connectionMaybe.isPresent()) {
                this.tryPersistServerNamespaceTable((OpcuaClient)connectionMaybe.get(), reconnectedEvent.getServerId(), 10);
            }
        }
        catch (Exception e) {
            log.error("Unable to persist namespace table for server: {}", (Object)reconnectedEvent.getServerId(), (Object)e);
        }
    }

    public DeviceTypeMappedNodeCollection deviceTypeNodeMappingsByServerId(String serverId) {
        return this.mappedNodesRepository.get(serverId);
    }

    private void tryPersistServerNamespaceTable(OpcuaClient uaClient, String serverId, int retries) throws OpcuaClientException, InterruptedException {
        try {
            this.persistServerNamespaceTable(uaClient, serverId);
        }
        catch (Exception e) {
            if (retries == 0) {
                throw e;
            }
            log.warn("Unable to persist namespace table for server: {}, still {} retries", new Object[]{serverId, retries, e});
            Thread.sleep(500L);
            this.tryPersistServerNamespaceTable(uaClient, serverId, --retries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistServerNamespaceTable(OpcuaClient uaClient, String serverId) throws OpcuaClientException {
        NamespaceTable serverNamespaceTable = uaClient.getNamespaceTable(true);
        if (serverNamespaceTable != null) {
            if (log.isTraceEnabled()) {
                log.trace("Namespace table: {}", (Object)serverNamespaceTable);
            }
            List existingNsTable = null;
            try {
                ManagedObjectRepresentation existingServerMO = this.inventoryRepository.get(GId.asGId((String)serverId));
                existingNsTable = (List)existingServerMO.get("c8y_ua_NamespaceTable");
            }
            finally {
                if (!(CollectionUtils.isEmpty((Collection)existingNsTable) || existingNsTable.equals(new ArrayList<String>(Arrays.asList(serverNamespaceTable.toArray()))) || CollectionUtils.isEmpty((Collection)existingNsTable))) {
                    this.eventPublisher.publishEvent((Object)new NamespaceTableChangedEvent(ServerIdentifier.of((String)serverId)));
                }
                ManagedObjectRepresentation serverMo = new ManagedObjectRepresentation();
                serverMo.setId(GId.asGId((String)serverId));
                serverMo.setProperty("c8y_ua_NamespaceTable", (Object)serverNamespaceTable.toArray());
                this.inventoryRepository.update(serverMo, this.processingModeConfiguration.getServerUpdateProcessingMode());
                log.info("Namespace table persisted for server: {}", (Object)serverId);
            }
        }
    }

    private void disconnectOnDestroy(ServerIdentifier serverIdentifier) {
        ClientWithConfig clientWithConfig = (ClientWithConfig)this.clientMap.remove(serverIdentifier);
        if (Objects.isNull(clientWithConfig)) {
            return;
        }
        OpcuaClient client = clientWithConfig.client;
        if (client.isConnected()) {
            this.disconnect(client);
        } else {
            log.info("Client was already disconnected, skipping client disconnection.");
        }
    }

    @PreDestroy
    public void closeAllConnections() {
        log.info("Disconnecting from server(s)");
        try {
            this.clientMap.keySet().forEach(arg_0 -> this.disconnectOnDestroy(arg_0));
        }
        finally {
            this.clientMap.clear();
        }
    }

    private void disconnect(OpcuaClient client) {
        if (!Objects.isNull(client) && client.isConnected()) {
            client.disconnect();
        }
    }

    private String getLabel(Boolean validateEndpoints) {
        if (Objects.isNull(validateEndpoints)) {
            return "NO SETTING";
        }
        if (validateEndpoints.booleanValue()) {
            return "FORCE ENABLE";
        }
        return "FORCE DISABLE";
    }

    public Map<ServerIdentifier, ClientWithConfig> getClientMap() {
        return this.clientMap;
    }
}

