/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.bootstrap.service;

import com.cumulocity.model.ID;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.bootstrap.service.BootstrapService;
import com.cumulocity.opcua.client.gateway.configuration.GatewayGeneralConfiguration;
import com.cumulocity.opcua.client.gateway.jmx.ServerMonitoringMBean;
import com.cumulocity.opcua.client.gateway.platform.configuration.condition.PlatformThinEdgeProxyCondition;
import com.cumulocity.opcua.client.gateway.platform.factory.IdentityFactory;
import com.cumulocity.opcua.client.gateway.platform.factory.ManagedObjectFactory;
import com.cumulocity.opcua.client.gateway.platform.repository.IdentityRepository;
import com.cumulocity.opcua.common.repository.InventoryRepository;
import com.cumulocity.rest.representation.identity.ExternalIDRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.option.SystemOptionApi;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={PlatformThinEdgeProxyCondition.class})
public class BootstrapServiceThinEdgeProxy
extends BootstrapService
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(BootstrapServiceThinEdgeProxy.class);
    @Value(value="${gateway.thinEdge.deviceId}")
    private String thinEdgeDeviceId;

    public BootstrapServiceThinEdgeProxy(ServerMonitoringMBean mbean, GatewayGeneralConfiguration configuration, ApplicationEventPublisher eventPublisher, IdentityRepository identityRepository, InventoryRepository inventoryRepository, SystemOptionApi systemOptionApi) {
        super(mbean, configuration, eventPublisher, identityRepository, inventoryRepository, systemOptionApi);
    }

    protected void onInvalidCredentials() {
        log.warn("Invalid device credentials detected!");
    }

    protected ManagedObjectRepresentation createDevice(ID deviceId) {
        Optional externalIDRepresentationThinEdge = this.identityRepository.get(IdentityFactory.createID((String)this.thinEdgeDeviceId));
        if (externalIDRepresentationThinEdge.isEmpty()) {
            log.error("ThinEdge managed object not found! Shutting down gateway ...");
            System.exit(1);
        }
        GId thinEdgeId = ((ExternalIDRepresentation)externalIDRepresentationThinEdge.get()).getManagedObject().getId();
        log.debug("ThinEdge managed object found: {}", (Object)thinEdgeId);
        ManagedObjectRepresentation deviceMO = this.inventoryRepository.createChildDevice(ManagedObjectFactory.create((String)this.configuration.getGatewayName()), thinEdgeId);
        log.info("Device created with ID: {}", (Object)deviceMO.getId().getValue());
        this.identityRepository.create(deviceId, deviceMO.getId());
        return deviceMO;
    }

    public void setThinEdgeDeviceId(String thinEdgeDeviceId) {
        this.thinEdgeDeviceId = thinEdgeDeviceId;
    }
}

