/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.subscription.model;

import com.cumulocity.opcua.client.gateway.subscription.model.SubscribedItem;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscribedItemId;
import com.cumulocity.opcua.common.model.mapping.ExecutableMappingAction;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import java.util.Collection;

public class SubscribedItem {
    private final SubscribedItemId subscribedItemId;
    private UnsignedInteger subscriptionId;
    private final String deviceTypeId;
    private final String rootNodeId;
    private final String subscriptionType;
    private final Collection<ExecutableMappingAction> mappedActions;

    public String getDeviceTypeId() {
        if (this.deviceTypeId != null) {
            return this.deviceTypeId;
        }
        return this.subscribedItemId.getDeviceTypeId();
    }

    public String getRootNodeId() {
        if (this.rootNodeId != null) {
            return this.rootNodeId;
        }
        return this.subscribedItemId.getRootNodeId();
    }

    public UnsignedInteger getMonitoredItemId() {
        return this.subscribedItemId.getMonitoredItemId();
    }

    public String getServerId() {
        return this.subscribedItemId.getServerId();
    }

    public String getTargetNodeId() {
        return this.subscribedItemId.getTargetNodeId();
    }

    public static SubscribedItemBuilder builder() {
        return new SubscribedItemBuilder();
    }

    public SubscribedItem(SubscribedItemId subscribedItemId, String deviceTypeId, String rootNodeId, String subscriptionType, Collection<ExecutableMappingAction> mappedActions) {
        this.subscribedItemId = subscribedItemId;
        this.deviceTypeId = deviceTypeId;
        this.rootNodeId = rootNodeId;
        this.subscriptionType = subscriptionType;
        this.mappedActions = mappedActions;
    }

    public SubscribedItemId getSubscribedItemId() {
        return this.subscribedItemId;
    }

    public UnsignedInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getSubscriptionType() {
        return this.subscriptionType;
    }

    public Collection<ExecutableMappingAction> getMappedActions() {
        return this.mappedActions;
    }

    public SubscribedItem(SubscribedItemId subscribedItemId, UnsignedInteger subscriptionId, String deviceTypeId, String rootNodeId, String subscriptionType, Collection<ExecutableMappingAction> mappedActions) {
        this.subscribedItemId = subscribedItemId;
        this.subscriptionId = subscriptionId;
        this.deviceTypeId = deviceTypeId;
        this.rootNodeId = rootNodeId;
        this.subscriptionType = subscriptionType;
        this.mappedActions = mappedActions;
    }

    public String toString() {
        return "SubscribedItem(subscribedItemId=" + String.valueOf(this.getSubscribedItemId()) + ", subscriptionId=" + String.valueOf(this.getSubscriptionId()) + ", deviceTypeId=" + this.getDeviceTypeId() + ", rootNodeId=" + this.getRootNodeId() + ", subscriptionType=" + this.getSubscriptionType() + ", mappedActions=" + String.valueOf(this.getMappedActions()) + ")";
    }

    public void setSubscriptionId(UnsignedInteger subscriptionId) {
        this.subscriptionId = subscriptionId;
    }
}

